"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardOutcomeValidation = void 0;
var _react = require("react");
var _plugin_services = require("../../services/plugin_services");
var _dashboard_constants = require("../../dashboard_constants");
var _dashboard_mount_context = require("./dashboard_mount_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useDashboardOutcomeValidation = () => {
  const [aliasId, setAliasId] = (0, _react.useState)();
  const [outcome, setOutcome] = (0, _react.useState)();
  const [savedObjectId, setSavedObjectId] = (0, _react.useState)();
  const {
    scopedHistory: getScopedHistory
  } = (0, _dashboard_mount_context.useDashboardMountContext)();
  const scopedHistory = getScopedHistory === null || getScopedHistory === void 0 ? void 0 : getScopedHistory();

  /**
   * Unpack dashboard services
   */
  const {
    screenshotMode,
    spaces
  } = _plugin_services.pluginServices.getServices();
  const validateOutcome = (0, _react.useCallback)(({
    dashboardFound,
    resolveMeta,
    dashboardId
  }) => {
    if (!dashboardFound) {
      return 'invalid';
    }
    if (resolveMeta && dashboardId) {
      const {
        outcome: loadOutcome,
        aliasTargetId: alias,
        aliasPurpose
      } = resolveMeta;
      /**
       * Handle saved object resolve alias outcome by redirecting.
       */
      if (loadOutcome === 'aliasMatch' && dashboardId && alias) {
        const path = scopedHistory.location.hash.replace(dashboardId, alias);
        if (screenshotMode.isScreenshotMode()) {
          scopedHistory.replace(path); // redirect without the toast when in screenshot mode.
        } else {
          var _spaces$redirectLegac;
          (_spaces$redirectLegac = spaces.redirectLegacyUrl) === null || _spaces$redirectLegac === void 0 ? void 0 : _spaces$redirectLegac.call(spaces, {
            path,
            aliasPurpose
          });
        }
        return 'redirected'; // redirected. Stop loading dashboard.
      }

      setAliasId(alias);
      setOutcome(loadOutcome);
      setSavedObjectId(dashboardId);
    }
    return 'valid';
  }, [scopedHistory, screenshotMode, spaces]);
  const getLegacyConflictWarning = (0, _react.useMemo)(() => {
    if (savedObjectId && outcome === 'conflict' && aliasId) {
      return () => {
        var _spaces$getLegacyUrlC;
        return (_spaces$getLegacyUrlC = spaces.getLegacyUrlConflict) === null || _spaces$getLegacyUrlC === void 0 ? void 0 : _spaces$getLegacyUrlC.call(spaces, {
          currentObjectId: savedObjectId,
          otherObjectId: aliasId,
          otherObjectPath: `#${(0, _dashboard_constants.createDashboardEditUrl)(aliasId)}${scopedHistory.location.search}`
        });
      };
    }
    return null;
  }, [aliasId, outcome, savedObjectId, scopedHistory, spaces]);
  return {
    validateOutcome,
    getLegacyConflictWarning
  };
};
exports.useDashboardOutcomeValidation = useDashboardOutcomeValidation;