"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openReplacePanelFlyout = openReplacePanelFlyout;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _replace_panel_flyout = require("./replace_panel_flyout");
var _plugin_services = require("../services/plugin_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function openReplacePanelFlyout(options) {
  const {
    embeddable,
    panelToRemove,
    savedObjectFinder
  } = options;
  const {
    settings: {
      theme: {
        theme$
      }
    },
    overlays: {
      openFlyout
    }
  } = _plugin_services.pluginServices.getServices();
  const flyoutSession = openFlyout((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_replace_panel_flyout.ReplacePanelFlyout, {
    container: embeddable,
    onClose: () => {
      if (flyoutSession) {
        flyoutSession.close();
      }
    },
    panelToRemove: panelToRemove,
    savedObjectsFinder: savedObjectFinder
  }), {
    theme$
  }), {
    'data-test-subj': 'dashboardReplacePanel',
    ownFocus: true
  });
}