"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersNotificationAction = exports.BADGE_FILTERS_NOTIFICATION = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _public3 = require("@kbn/kibana-react-plugin/public");
var _filters_notification_popover = require("./filters_notification_popover");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _plugin_services = require("../services/plugin_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const BADGE_FILTERS_NOTIFICATION = 'ACTION_FILTERS_NOTIFICATION';
exports.BADGE_FILTERS_NOTIFICATION = BADGE_FILTERS_NOTIFICATION;
class FiltersNotificationAction {
  constructor() {
    (0, _defineProperty2.default)(this, "id", BADGE_FILTERS_NOTIFICATION);
    (0, _defineProperty2.default)(this, "type", BADGE_FILTERS_NOTIFICATION);
    (0, _defineProperty2.default)(this, "order", 2);
    (0, _defineProperty2.default)(this, "displayName", _dashboard_actions_strings.dashboardFilterNotificationActionStrings.getDisplayName());
    (0, _defineProperty2.default)(this, "icon", 'filter');
    (0, _defineProperty2.default)(this, "applicationService", void 0);
    (0, _defineProperty2.default)(this, "embeddableService", void 0);
    (0, _defineProperty2.default)(this, "settingsService", void 0);
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      const {
        embeddable
      } = context;
      const editPanelAction = new _public.EditPanelAction(this.embeddableService.getEmbeddableFactory, this.applicationService, this.embeddableService.getStateTransfer());
      const {
        Provider: KibanaReactContextProvider
      } = (0, _public3.createKibanaReactContext)({
        uiSettings: this.settingsService.uiSettings
      });
      return /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(_filters_notification_popover.FiltersNotificationPopover, {
        editPanelAction: editPanelAction,
        displayName: this.displayName,
        context: context,
        icon: this.getIconType({
          embeddable
        }),
        id: this.id
      }));
    });
    (0, _defineProperty2.default)(this, "isCompatible", async ({
      embeddable
    }) => {
      var _embeddable$getInput;
      // add all possible early returns to avoid the async import unless absolutely necessary
      if ((0, _public.isErrorEmbeddable)(embeddable) || !embeddable.getRoot().isContainer || ((_embeddable$getInput = embeddable.getInput()) === null || _embeddable$getInput === void 0 ? void 0 : _embeddable$getInput.viewMode) !== _public.ViewMode.EDIT || !(0, _public.isFilterableEmbeddable)(embeddable)) {
        return false;
      }
      if ((await embeddable.getFilters()).length > 0) return true;

      // all early returns failed, so go ahead and check the query now
      const {
        isOfQueryType,
        isOfAggregateQueryType
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
      const query = await embeddable.getQuery();
      return isOfQueryType(query) && query.query !== '' || isOfAggregateQueryType(query);
    });
    (0, _defineProperty2.default)(this, "execute", async () => {});
    ({
      application: this.applicationService,
      embeddable: this.embeddableService,
      settings: this.settingsService
    } = _plugin_services.pluginServices.getServices());
  }
  getDisplayName({
    embeddable
  }) {
    if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
      throw new _public2.IncompatibleActionError();
    }
    return this.displayName;
  }
  getIconType({
    embeddable
  }) {
    if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
      throw new _public2.IncompatibleActionError();
    }
    return this.icon;
  }
}
exports.FiltersNotificationAction = FiltersNotificationAction;