"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardUnlinkFromLibraryActionStrings = exports.dashboardReplacePanelActionStrings = exports.dashboardLibraryNotificationStrings = exports.dashboardFilterNotificationActionStrings = exports.dashboardExportCsvActionStrings = exports.dashboardExpandPanelActionStrings = exports.dashboardCopyToDashboardActionStrings = exports.dashboardClonePanelActionStrings = exports.dashboardAddToLibraryActionStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboardCopyToDashboardActionStrings = {
  getDisplayName: () => _i18n.i18n.translate('dashboard.panel.copyToDashboard.title', {
    defaultMessage: 'Copy to dashboard'
  }),
  getCancelButtonName: () => _i18n.i18n.translate('dashboard.panel.copyToDashboard.cancel', {
    defaultMessage: 'Cancel'
  }),
  getAcceptButtonName: () => _i18n.i18n.translate('dashboard.panel.copyToDashboard.goToDashboard', {
    defaultMessage: 'Copy and go to dashboard'
  }),
  getNewDashboardOption: () => _i18n.i18n.translate('dashboard.panel.copyToDashboard.newDashboardOptionLabel', {
    defaultMessage: 'New dashboard'
  }),
  getExistingDashboardOption: () => _i18n.i18n.translate('dashboard.panel.copyToDashboard.existingDashboardOptionLabel', {
    defaultMessage: 'Existing dashboard'
  }),
  getDescription: () => _i18n.i18n.translate('dashboard.panel.copyToDashboard.description', {
    defaultMessage: 'Choose the destination dashboard.'
  })
};
exports.dashboardCopyToDashboardActionStrings = dashboardCopyToDashboardActionStrings;
const dashboardAddToLibraryActionStrings = {
  getDisplayName: () => _i18n.i18n.translate('dashboard.panel.AddToLibrary', {
    defaultMessage: 'Save to library'
  }),
  getSuccessMessage: panelTitle => _i18n.i18n.translate('dashboard.panel.addToLibrary.successMessage', {
    defaultMessage: `Panel {panelTitle} was added to the visualize library`,
    values: {
      panelTitle
    }
  })
};
exports.dashboardAddToLibraryActionStrings = dashboardAddToLibraryActionStrings;
const dashboardClonePanelActionStrings = {
  getDisplayName: () => _i18n.i18n.translate('dashboard.panel.clonePanel', {
    defaultMessage: 'Clone panel'
  }),
  getClonedTag: () => _i18n.i18n.translate('dashboard.panel.title.clonedTag', {
    defaultMessage: 'copy'
  }),
  getSuccessMessage: () => _i18n.i18n.translate('dashboard.panel.clonedToast', {
    defaultMessage: 'Cloned panel'
  })
};
exports.dashboardClonePanelActionStrings = dashboardClonePanelActionStrings;
const dashboardExpandPanelActionStrings = {
  getMinimizeTitle: () => _i18n.i18n.translate('dashboard.actions.toggleExpandPanelMenuItem.expandedDisplayName', {
    defaultMessage: 'Minimize'
  }),
  getMaximizeTitle: () => _i18n.i18n.translate('dashboard.actions.toggleExpandPanelMenuItem.notExpandedDisplayName', {
    defaultMessage: 'Maximize panel'
  })
};
exports.dashboardExpandPanelActionStrings = dashboardExpandPanelActionStrings;
const dashboardExportCsvActionStrings = {
  getDisplayName: () => _i18n.i18n.translate('dashboard.actions.DownloadCreateDrilldownAction.displayName', {
    defaultMessage: 'Download as CSV'
  }),
  getUntitledFilename: () => _i18n.i18n.translate('dashboard.actions.downloadOptionsUnsavedFilename', {
    defaultMessage: 'untitled'
  })
};
exports.dashboardExportCsvActionStrings = dashboardExportCsvActionStrings;
const dashboardUnlinkFromLibraryActionStrings = {
  getDisplayName: () => _i18n.i18n.translate('dashboard.panel.unlinkFromLibrary', {
    defaultMessage: 'Unlink from library'
  }),
  getSuccessMessage: panelTitle => _i18n.i18n.translate('dashboard.panel.unlinkFromLibrary.successMessage', {
    defaultMessage: `Panel {panelTitle} is no longer connected to the visualize library`,
    values: {
      panelTitle
    }
  })
};
exports.dashboardUnlinkFromLibraryActionStrings = dashboardUnlinkFromLibraryActionStrings;
const dashboardLibraryNotificationStrings = {
  getDisplayName: () => _i18n.i18n.translate('dashboard.panel.LibraryNotification', {
    defaultMessage: 'Visualize Library Notification'
  }),
  getTooltip: () => _i18n.i18n.translate('dashboard.panel.libraryNotification.toolTip', {
    defaultMessage: 'Editing this panel might affect other dashboards. To change this panel only, unlink it from the library.'
  }),
  getPopoverAriaLabel: () => _i18n.i18n.translate('dashboard.panel.libraryNotification.ariaLabel', {
    defaultMessage: 'View library information and unlink this panel'
  })
};
exports.dashboardLibraryNotificationStrings = dashboardLibraryNotificationStrings;
const dashboardReplacePanelActionStrings = {
  getDisplayName: () => _i18n.i18n.translate('dashboard.panel.removePanel.replacePanel', {
    defaultMessage: 'Replace panel'
  }),
  getSuccessMessage: savedObjectName => savedObjectName ? _i18n.i18n.translate('dashboard.addPanel.savedObjectAddedToContainerSuccessMessageTitle', {
    defaultMessage: '{savedObjectName} was added',
    values: {
      savedObjectName: `'${savedObjectName}'`
    }
  }) : _i18n.i18n.translate('dashboard.addPanel.panelAddedToContainerSuccessMessageTitle', {
    defaultMessage: 'A panel was added'
  }),
  getNoMatchingObjectsMessage: () => _i18n.i18n.translate('dashboard.addPanel.noMatchingObjectsMessage', {
    defaultMessage: 'No matching objects found.'
  })
};
exports.dashboardReplacePanelActionStrings = dashboardReplacePanelActionStrings;
const dashboardFilterNotificationActionStrings = {
  getDisplayName: () => _i18n.i18n.translate('dashboard.panel.filters', {
    defaultMessage: 'Panel filters'
  }),
  getEditButtonTitle: () => _i18n.i18n.translate('dashboard.panel.filters.modal.editButton', {
    defaultMessage: 'Edit filters'
  }),
  getCloseButtonTitle: () => _i18n.i18n.translate('dashboard.panel.filters.modal.closeButton', {
    defaultMessage: 'Close'
  }),
  getQueryTitle: () => _i18n.i18n.translate('dashboard.panel.filters.modal.queryTitle', {
    defaultMessage: 'Query'
  }),
  getFiltersTitle: () => _i18n.i18n.translate('dashboard.panel.filters.modal.filtersTitle', {
    defaultMessage: 'Filters'
  })
};
exports.dashboardFilterNotificationActionStrings = dashboardFilterNotificationActionStrings;