"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = void 0;
var t = _interopRequireWildcard(require("../action_types"));
var _utils = require("../../services/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  byId: {},
  selectedDetailId: null,
  selectedEditId: null
};
const success = action => `${action}_SUCCESS`;
const parseFollowerIndex = followerIndex => {
  // Extract status into boolean
  return {
    ...followerIndex,
    isPaused: followerIndex.status === 'paused'
  };
};
const reducer = (state = initialState, action) => {
  switch (action.type) {
    case success(t.FOLLOWER_INDEX_LOAD):
      {
        return {
          ...state,
          byId: (0, _utils.arrayToObject)(action.payload.indices.map(parseFollowerIndex), 'name')
        };
      }
    case success(t.FOLLOWER_INDEX_GET):
      {
        return {
          ...state,
          byId: {
            ...state.byId,
            [action.payload.name]: parseFollowerIndex(action.payload)
          }
        };
      }
    case t.FOLLOWER_INDEX_SELECT_DETAIL:
      {
        return {
          ...state,
          selectedDetailId: action.payload
        };
      }
    case t.FOLLOWER_INDEX_SELECT_EDIT:
      {
        return {
          ...state,
          selectedEditId: action.payload
        };
      }
    case success(t.FOLLOWER_INDEX_UNFOLLOW):
      {
        const byId = {
          ...state.byId
        };
        const {
          itemsUnfollowed
        } = action.payload;
        itemsUnfollowed.forEach(id => delete byId[id]);
        return {
          ...state,
          byId
        };
      }
    default:
      return state;
  }
};
exports.reducer = reducer;