"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectEditAutoFollowPattern = exports.selectDetailAutoFollowPattern = exports.saveAutoFollowPattern = exports.resumeAutoFollowPattern = exports.pauseAutoFollowPattern = exports.loadAutoFollowPatterns = exports.getAutoFollowPattern = exports.deleteAutoFollowPattern = void 0;
var _i18n = require("@kbn/i18n");
var _notifications = require("../../services/notifications");
var _constants = require("../../constants");
var _api = require("../../services/api");
var _routing = require("../../services/routing");
var t = _interopRequireWildcard(require("../action_types"));
var _api2 = require("./api");
var _selectors = require("../selectors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  AUTO_FOLLOW_PATTERN: scope
} = _constants.SECTIONS;
const selectDetailAutoFollowPattern = id => ({
  type: t.AUTO_FOLLOW_PATTERN_SELECT_DETAIL,
  payload: id
});
exports.selectDetailAutoFollowPattern = selectDetailAutoFollowPattern;
const selectEditAutoFollowPattern = id => ({
  type: t.AUTO_FOLLOW_PATTERN_SELECT_EDIT,
  payload: id
});
exports.selectEditAutoFollowPattern = selectEditAutoFollowPattern;
const loadAutoFollowPatterns = (isUpdating = false) => (0, _api2.sendApiRequest)({
  label: t.AUTO_FOLLOW_PATTERN_LOAD,
  scope,
  status: isUpdating ? _constants.API_STATUS.UPDATING : _constants.API_STATUS.LOADING,
  handler: async () => await (0, _api.loadAutoFollowPatterns)(isUpdating)
});
exports.loadAutoFollowPatterns = loadAutoFollowPatterns;
const getAutoFollowPattern = id => (0, _api2.sendApiRequest)({
  label: t.AUTO_FOLLOW_PATTERN_GET,
  scope: `${scope}-get`,
  handler: async () => await (0, _api.getAutoFollowPattern)(id)
});
exports.getAutoFollowPattern = getAutoFollowPattern;
const saveAutoFollowPattern = (id, autoFollowPattern, isUpdating = false) => (0, _api2.sendApiRequest)({
  label: isUpdating ? t.AUTO_FOLLOW_PATTERN_UPDATE : t.AUTO_FOLLOW_PATTERN_CREATE,
  status: _constants.API_STATUS.SAVING,
  scope: `${scope}-save`,
  handler: async () => {
    if (isUpdating) {
      return await (0, _api.updateAutoFollowPattern)(id, autoFollowPattern);
    }
    return await (0, _api.createAutoFollowPattern)({
      id,
      ...autoFollowPattern
    });
  },
  onSuccess() {
    const successMessage = isUpdating ? _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.updateAction.successNotificationTitle', {
      defaultMessage: `Auto-follow pattern '{name}' updated successfully`,
      values: {
        name: id
      }
    }) : _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.addAction.successNotificationTitle', {
      defaultMessage: `Added auto-follow pattern '{name}'`,
      values: {
        name: id
      }
    });
    (0, _notifications.getToasts)().addSuccess(successMessage);
    _routing.routing.navigate(`/auto_follow_patterns`, {
      pattern: encodeURIComponent(id)
    });
  }
});
exports.saveAutoFollowPattern = saveAutoFollowPattern;
const deleteAutoFollowPattern = id => (0, _api2.sendApiRequest)({
  label: t.AUTO_FOLLOW_PATTERN_DELETE,
  scope: `${scope}-delete`,
  status: _constants.API_STATUS.DELETING,
  handler: async () => (0, _api.deleteAutoFollowPattern)(id),
  onSuccess(response, dispatch, getState) {
    /**
     * We can have 1 or more auto-follow pattern delete operation
     * that can fail or succeed. We will show 1 toast notification for each.
     */
    if (response.errors.length) {
      const hasMultipleErrors = response.errors.length > 1;
      const errorMessage = hasMultipleErrors ? _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.removeAction.errorMultipleNotificationTitle', {
        defaultMessage: `Error removing {count} auto-follow patterns`,
        values: {
          count: response.errors.length
        }
      }) : _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.removeAction.errorSingleNotificationTitle', {
        defaultMessage: `Error removing the '{name}' auto-follow pattern`,
        values: {
          name: response.errors[0].id
        }
      });
      (0, _notifications.getToasts)().addDanger(errorMessage);
    }
    if (response.itemsDeleted.length) {
      const hasMultipleDelete = response.itemsDeleted.length > 1;
      const successMessage = hasMultipleDelete ? _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.removeAction.successMultipleNotificationTitle', {
        defaultMessage: `{count} auto-follow patterns were removed`,
        values: {
          count: response.itemsDeleted.length
        }
      }) : _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.removeAction.successSingleNotificationTitle', {
        defaultMessage: `Auto-follow pattern '{name}' was removed`,
        values: {
          name: response.itemsDeleted[0]
        }
      });
      (0, _notifications.getToasts)().addSuccess(successMessage);

      // If we've just deleted a pattern we were looking at, we need to close the panel.
      const autoFollowPatternId = (0, _selectors.getSelectedAutoFollowPatternId)('detail')(getState());
      if (response.itemsDeleted.includes(autoFollowPatternId)) {
        dispatch(selectDetailAutoFollowPattern(null));
      }
    }
  }
});
exports.deleteAutoFollowPattern = deleteAutoFollowPattern;
const pauseAutoFollowPattern = id => (0, _api2.sendApiRequest)({
  label: t.AUTO_FOLLOW_PATTERN_PAUSE,
  scope: `${scope}-pause`,
  status: _constants.API_STATUS.UPDATING,
  handler: () => (0, _api.pauseAutoFollowPattern)(id),
  onSuccess: response => {
    /**
     * We can have 1 or more auto-follow pattern pause operations
     * that can fail or succeed. We will show 1 toast notification for each.
     */
    if (response.errors.length) {
      const hasMultipleErrors = response.errors.length > 1;
      const errorMessage = hasMultipleErrors ? _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.pauseAction.errorMultipleNotificationTitle', {
        defaultMessage: `Error pausing {count} auto-follow patterns`,
        values: {
          count: response.errors.length
        }
      }) : _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.pauseAction.errorSingleNotificationTitle', {
        defaultMessage: `Error pausing the '{name}' auto-follow pattern`,
        values: {
          name: response.errors[0].id
        }
      });
      (0, _notifications.getToasts)().addDanger(errorMessage);
    }
    if (response.itemsPaused.length) {
      const hasMultiple = response.itemsPaused.length > 1;
      const successMessage = hasMultiple ? _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.pauseAction.successMultipleNotificationTitle', {
        defaultMessage: `{count} auto-follow patterns were paused`,
        values: {
          count: response.itemsPaused.length
        }
      }) : _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.pauseAction.successSingleNotificationTitle', {
        defaultMessage: `Auto-follow pattern '{name}' was paused`,
        values: {
          name: response.itemsPaused[0]
        }
      });
      (0, _notifications.getToasts)().addSuccess(successMessage);
    }
  }
});
exports.pauseAutoFollowPattern = pauseAutoFollowPattern;
const resumeAutoFollowPattern = id => (0, _api2.sendApiRequest)({
  label: t.AUTO_FOLLOW_PATTERN_RESUME,
  scope: `${scope}-resume`,
  status: _constants.API_STATUS.UPDATING,
  handler: () => (0, _api.resumeAutoFollowPattern)(id),
  onSuccess: response => {
    /**
     * We can have 1 or more auto-follow pattern resume operations
     * that can fail or succeed. We will show 1 toast notification for each.
     */
    if (response.errors.length) {
      const hasMultipleErrors = response.errors.length > 1;
      const errorMessage = hasMultipleErrors ? _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.resumeAction.errorMultipleNotificationTitle', {
        defaultMessage: `Error resuming {count} auto-follow patterns`,
        values: {
          count: response.errors.length
        }
      }) : _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.resumeAction.errorSingleNotificationTitle', {
        defaultMessage: `Error resuming the '{name}' auto-follow pattern`,
        values: {
          name: response.errors[0].id
        }
      });
      (0, _notifications.getToasts)().addDanger(errorMessage);
    }
    if (response.itemsResumed.length) {
      const hasMultiple = response.itemsResumed.length > 1;
      const successMessage = hasMultiple ? _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.resumeAction.successMultipleNotificationTitle', {
        defaultMessage: `{count} auto-follow patterns were resumed`,
        values: {
          count: response.itemsResumed.length
        }
      }) : _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.resumeAction.successSingleNotificationTitle', {
        defaultMessage: `Auto-follow pattern '{name}' was resumed`,
        values: {
          name: response.itemsResumed[0]
        }
      });
      (0, _notifications.getToasts)().addSuccess(successMessage);
    }
  }
});
exports.resumeAutoFollowPattern = resumeAutoFollowPattern;