"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FollowerIndexRequestFlyout = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _follower_index_serialization = require("../../../../common/services/follower_index_serialization");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FollowerIndexRequestFlyout extends _react.PureComponent {
  render() {
    const {
      name,
      followerIndex,
      close
    } = this.props;
    const endpoint = `PUT /${name ? name : '<followerIndexName>'}/_ccr/follow`;
    const payload = JSON.stringify((0, _follower_index_serialization.serializeFollowerIndex)(followerIndex), null, 2);
    const request = `${endpoint}\n${payload}`;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      maxWidth: 480,
      onClose: close
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexForm.requestFlyout.title",
      defaultMessage: "Request"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexForm.requestFlyout.descriptionText",
      defaultMessage: "This Elasticsearch request will create this follower index."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true
    }, request)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      onClick: close,
      flush: "left"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexForm.requestFlyout.closeButtonLabel",
      defaultMessage: "Close"
    }))));
  }
}
exports.FollowerIndexRequestFlyout = FollowerIndexRequestFlyout;
(0, _defineProperty2.default)(FollowerIndexRequestFlyout, "propTypes", {
  close: _propTypes.default.func.isRequired,
  name: _propTypes.default.string.isRequired,
  followerIndex: _propTypes.default.object.isRequired
});