"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FollowerIndexPauseProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _actions = require("../../store/actions");
var _utils = require("../../../../common/services/utils");
var _follower_index_default_settings = require("../../services/follower_index_default_settings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FollowerIndexPauseProviderUi extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isModalOpen: false,
      indices: []
    });
    (0, _defineProperty2.default)(this, "onMouseOverModal", event => {
      // This component can sometimes be used inside of an EuiToolTip, in which case mousing over
      // the modal can trigger the tooltip. Stopping propagation prevents this.
      event.stopPropagation();
    });
    (0, _defineProperty2.default)(this, "pauseFollowerIndex", index => {
      this.setState({
        isModalOpen: true,
        indices: (0, _utils.arrify)(index)
      });
    });
    (0, _defineProperty2.default)(this, "onConfirm", () => {
      this.props.pauseFollowerIndex(this.state.indices.map(index => index.name));
      this.setState({
        isModalOpen: false,
        indices: []
      });
      this.props.onConfirm && this.props.onConfirm();
    });
    (0, _defineProperty2.default)(this, "closeConfirmModal", () => {
      this.setState({
        isModalOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "renderModal", () => {
      const {
        indices
      } = this.state;
      const isSingle = indices.length === 1;
      const title = isSingle ? _i18n.i18n.translate('xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.pauseSingleTitle', {
        defaultMessage: `Pause replication to follower index '{name}'?`,
        values: {
          name: indices[0].name
        }
      }) : _i18n.i18n.translate('xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.pauseMultipleTitle', {
        defaultMessage: 'Pause replication to {count} follower indices?',
        values: {
          count: indices.length
        }
      });
      const hasCustomSettings = indices.some(index => !(0, _follower_index_default_settings.areAllSettingsDefault)(index));
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
        _react.default.createElement(_eui.EuiConfirmModal, {
          title: title,
          onCancel: this.closeConfirmModal,
          onConfirm: this.onConfirm,
          cancelButtonText: _i18n.i18n.translate('xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.cancelButtonText', {
            defaultMessage: 'Cancel'
          }),
          buttonColor: hasCustomSettings ? 'danger' : 'primary',
          confirmButtonText: _i18n.i18n.translate('xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.confirmButtonText', {
            defaultMessage: 'Pause replication'
          }),
          onMouseOver: this.onMouseOverModal,
          "data-test-subj": "pauseReplicationConfirmation"
        }, hasCustomSettings && /*#__PURE__*/_react.default.createElement("p", null, isSingle ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.singlePauseDescriptionWithSettingWarning",
          defaultMessage: "Pausing replication to this follower index clears its custom advanced settings."
        }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.multiplePauseDescriptionWithSettingWarning",
          defaultMessage: "Pausing replication to a follower index clears its custom advanced settings."
        })), !isSingle && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.multiplePauseDescription",
          defaultMessage: "Replication will pause on these follower indices:"
        })), /*#__PURE__*/_react.default.createElement("ul", null, indices.map(index => /*#__PURE__*/_react.default.createElement("li", {
          key: index.name
        }, index.name)))))
      );
    });
  }
  render() {
    const {
      children
    } = this.props;
    const {
      isModalOpen
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children(this.pauseFollowerIndex), isModalOpen && this.renderModal());
  }
}
(0, _defineProperty2.default)(FollowerIndexPauseProviderUi, "propTypes", {
  onConfirm: _propTypes.default.func
});
const mapDispatchToProps = dispatch => ({
  pauseFollowerIndex: id => dispatch((0, _actions.pauseFollowerIndex)(id))
});
const FollowerIndexPauseProvider = (0, _reactRedux.connect)(undefined, mapDispatchToProps)(FollowerIndexPauseProviderUi);
exports.FollowerIndexPauseProvider = FollowerIndexPauseProvider;