"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUpgradeableConfig = getUpgradeableConfig;
var _semver = _interopRequireDefault(require("semver"));
var _is_config_version_upgradeable = require("./is_config_version_upgradeable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 *  Find the most recent SavedConfig that is upgradeable to the specified version
 *  @param {Object} options
 *  @property {SavedObjectsClient} savedObjectsClient
 *  @property {string} version
 *  @property {type} `config` or `config-global`
 *  @return {Promise<SavedConfig|undefined>}
 */
async function getUpgradeableConfig({
  savedObjectsClient,
  version,
  type
}) {
  // attempt to find a config we can upgrade
  const {
    saved_objects: savedConfigs
  } = await savedObjectsClient.find({
    type,
    page: 1,
    perPage: 1000,
    sortField: 'buildNum',
    sortOrder: 'desc'
  });

  // try to find a config that we can upgrade
  const matchingResults = savedConfigs.filter(savedConfig => (0, _is_config_version_upgradeable.isConfigVersionUpgradeable)(savedConfig.id, version));
  const mostRecentConfig = getMostRecentConfig(matchingResults);
  if (mostRecentConfig) {
    return {
      id: mostRecentConfig.id,
      attributes: mostRecentConfig.attributes
    };
  }
  return null;
}
const getMostRecentConfig = results => {
  return results.reduce((mostRecent, current) => {
    if (!mostRecent) {
      return current;
    }
    return _semver.default.gt(mostRecent.id, current.id) ? mostRecent : current;
  }, undefined);
};