"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelStageMap = exports.model = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _retry_state = require("../../model/retry_state");
var _helpers = require("../../model/helpers");
var _actions = require("../actions");
var Stages = _interopRequireWildcard(require("./stages"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const modelStageMap = {
  INIT: Stages.init,
  CREATE_TARGET_INDEX: Stages.createTargetIndex,
  UPDATE_ALIASES: Stages.updateAliases,
  UPDATE_INDEX_MAPPINGS: Stages.updateIndexMappings,
  UPDATE_INDEX_MAPPINGS_WAIT_FOR_TASK: Stages.updateIndexMappingsWaitForTask,
  UPDATE_MAPPING_MODEL_VERSIONS: Stages.updateMappingModelVersion,
  INDEX_STATE_UPDATE_DONE: Stages.indexStateUpdateDone,
  DOCUMENTS_UPDATE_INIT: Stages.documentsUpdateInit,
  SET_DOC_MIGRATION_STARTED: Stages.setDocMigrationStarted,
  SET_DOC_MIGRATION_STARTED_WAIT_FOR_INSTANCES: Stages.setDocMigrationStartedWaitForInstances,
  CLEANUP_UNKNOWN_AND_EXCLUDED_DOCS: Stages.cleanupUnknownAndExcludedDocs,
  CLEANUP_UNKNOWN_AND_EXCLUDED_DOCS_WAIT_FOR_TASK: Stages.cleanupUnknownAndExcludedDocsWaitForTask,
  CLEANUP_UNKNOWN_AND_EXCLUDED_DOCS_REFRESH: Stages.cleanupUnknownAndExcludedDocsRefresh,
  OUTDATED_DOCUMENTS_SEARCH_OPEN_PIT: Stages.outdatedDocumentsSearchOpenPit,
  OUTDATED_DOCUMENTS_SEARCH_READ: Stages.outdatedDocumentsSearchRead,
  OUTDATED_DOCUMENTS_SEARCH_TRANSFORM: Stages.outdatedDocumentsSearchTransform,
  OUTDATED_DOCUMENTS_SEARCH_BULK_INDEX: Stages.outdatedDocumentsSearchBulkIndex,
  OUTDATED_DOCUMENTS_SEARCH_CLOSE_PIT: Stages.outdatedDocumentsSearchClosePit,
  OUTDATED_DOCUMENTS_SEARCH_REFRESH: Stages.outdatedDocumentsSearchRefresh,
  UPDATE_DOCUMENT_MODEL_VERSIONS: Stages.updateDocumentModelVersion,
  UPDATE_DOCUMENT_MODEL_VERSIONS_WAIT_FOR_INSTANCES: Stages.updateDocumentModelVersionWaitForInstances
};
exports.modelStageMap = modelStageMap;
const model = (current, response, context) => {
  if (Either.isLeft(response)) {
    if ((0, _actions.isTypeof)(response.left, 'retryable_es_client_error')) {
      return (0, _retry_state.delayRetryState)(current, response.left.message, context.maxRetryAttempts);
    }
  } else {
    current = (0, _retry_state.resetRetryState)(current);
  }
  if (current.controlState === 'DONE' || current.controlState === 'FATAL') {
    return (0, _helpers.throwBadControlState)(current);
  }
  const stageHandler = modelStageMap[current.controlState];
  if (!stageHandler) {
    return (0, _helpers.throwBadControlState)(current);
  }
  return stageHandler(current, response, context);
};
exports.model = model;