"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationHelper = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Repository helper for document migrations.
 */
class MigrationHelper {
  constructor({
    migrator
  }) {
    (0, _defineProperty2.default)(this, "migrator", void 0);
    this.migrator = migrator;
  }

  /**
   * Migrate the given SO document, throwing if a downgrade is required.
   * This function is meant to be used by write APIs (create, update) for documents provided as input.
   * before storing it in the index. It will therefore throw if the document is in a higher / unknown version.
   */
  migrateInputDocument(document) {
    return this.migrator.migrateDocument(document, {
      allowDowngrade: false
    });
  }

  /**
   * Migrate the given SO document, accepting downgrades.
   * This function is meant to be used by read APIs (get, find) for documents fetched from the index.
   * It will therefore accept downgrading the document before returning it from the API.
   */
  migrateStorageDocument(document) {
    return this.migrator.migrateDocument(document, {
      allowDowngrade: true
    });
  }
}
exports.MigrationHelper = MigrationHelper;