"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeSliderPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _services = require("../../services");
var _range_slider_strings = require("./range_slider_strings");
var _range_slider_embeddable = require("../embeddable/range_slider_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RangeSliderPopover = ({
  onChange,
  value,
  rangeRef
}) => {
  const [fieldFormatter, setFieldFormatter] = (0, _react.useState)(() => toFormat => toFormat);

  // Controls Services Context
  const {
    dataViews: {
      get: getDataViewById
    }
  } = _services.pluginServices.getServices();
  const rangeSlider = (0, _range_slider_embeddable.useRangeSlider)();

  // Select current state from Redux using multiple selectors to avoid rerenders.
  const dataViewId = rangeSlider.select(state => state.output.dataViewId);
  const id = rangeSlider.select(state => state.explicitInput.id);
  const title = rangeSlider.select(state => state.explicitInput.title);
  const min = rangeSlider.select(state => state.componentState.min);
  const max = rangeSlider.select(state => state.componentState.max);
  const fieldSpec = rangeSlider.select(state => state.componentState.field);
  const isInvalid = rangeSlider.select(state => state.componentState.isInvalid);

  // Caches min and max displayed on popover open so the range slider doesn't resize as selections change
  const [rangeSliderMin, setRangeSliderMin] = (0, _react.useState)(min);
  const [rangeSliderMax, setRangeSliderMax] = (0, _react.useState)(max);
  (0, _useMount.default)(() => {
    const [lowerBoundSelection, upperBoundSelection] = [parseFloat(value[0]), parseFloat(value[1])];
    setRangeSliderMin(Math.min(min, isNaN(lowerBoundSelection) ? Infinity : lowerBoundSelection, isNaN(upperBoundSelection) ? Infinity : upperBoundSelection));
    setRangeSliderMax(Math.max(max, isNaN(lowerBoundSelection) ? -Infinity : lowerBoundSelection, isNaN(upperBoundSelection) ? -Infinity : upperBoundSelection));
  });

  // derive field formatter from fieldSpec and dataViewId
  (0, _react.useEffect)(() => {
    (async () => {
      if (!dataViewId || !fieldSpec) return;
      // dataViews are cached, and should always be available without having to hit ES.
      const dataView = await getDataViewById(dataViewId);
      setFieldFormatter(() => {
        var _dataView$getFormatte;
        return (_dataView$getFormatte = dataView === null || dataView === void 0 ? void 0 : dataView.getFormatterForField(fieldSpec).getConverterFor('text')) !== null && _dataView$getFormatte !== void 0 ? _dataView$getFormatte : toFormat => toFormat;
      });
    })();
  }, [fieldSpec, dataViewId, getDataViewById]);
  const ticks = (0, _react.useMemo)(() => {
    return [{
      value: min,
      label: fieldFormatter(String(min))
    }, {
      value: max,
      label: fieldFormatter(String(max))
    }];
  }, [min, max, fieldFormatter]);
  const levels = (0, _react.useMemo)(() => {
    return [{
      min,
      max,
      color: 'success'
    }];
  }, [min, max]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "rangeSlider__popover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, title), min !== -Infinity && max !== Infinity ? /*#__PURE__*/_react.default.createElement(_eui.EuiDualRange, {
    id: id,
    min: rangeSliderMin,
    max: rangeSliderMax,
    onChange: ([minSelection, maxSelection]) => {
      onChange([String(minSelection), String(maxSelection)]);
    },
    value: value,
    ticks: ticks,
    levels: levels,
    showTicks: true,
    fullWidth: true,
    ref: rangeRef,
    "data-test-subj": "rangeSlider__slider"
  }) : isInvalid ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "rangeSlider__helpText"
  }, _range_slider_strings.RangeSliderStrings.popover.getNoDataHelpText()) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "rangeSlider__helpText"
  }, _range_slider_strings.RangeSliderStrings.popover.getNoAvailableDataHelpText()));
};
exports.RangeSliderPopover = RangeSliderPopover;