"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeSliderButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
require("./range_slider.scss");
var _range_slider_embeddable = require("../embeddable/range_slider_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RangeSliderButton = ({
  value,
  onChange,
  isPopoverOpen,
  setIsPopoverOpen
}) => {
  const rangeSlider = (0, _range_slider_embeddable.useRangeSlider)();
  const min = rangeSlider.select(state => state.componentState.min);
  const max = rangeSlider.select(state => state.componentState.max);
  const isInvalid = rangeSlider.select(state => state.componentState.isInvalid);
  const id = rangeSlider.select(state => state.explicitInput.id);
  const isLoading = rangeSlider.select(state => state.output.loading);
  const onClick = (0, _react.useCallback)(event => {
    // the popover should remain open if the click/focus target is one of the number inputs
    if (isPopoverOpen && event.target instanceof HTMLInputElement) {
      return;
    }
    setIsPopoverOpen(true);
  }, [isPopoverOpen, setIsPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayoutDelimited, {
    fullWidth: true,
    onClick: onClick,
    isLoading: isLoading,
    className: "rangeSliderAnchor__button",
    "data-test-subj": `range-slider-control-${id}`,
    startControl: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      controlOnly: true,
      fullWidth: true,
      value: value[0] === String(min) ? '' : value[0],
      onChange: event => {
        onChange([event.target.value, value[1]]);
      },
      placeholder: String(min),
      isInvalid: isInvalid,
      className: 'rangeSliderAnchor__fieldNumber',
      "data-test-subj": 'rangeSlider__lowerBoundFieldNumber'
    }),
    endControl: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      controlOnly: true,
      fullWidth: true,
      value: value[1] === String(max) ? '' : value[1],
      onChange: event => {
        onChange([value[0], event.target.value]);
      },
      placeholder: String(max),
      isInvalid: isInvalid,
      className: 'rangeSliderAnchor__fieldNumber',
      "data-test-subj": 'rangeSlider__upperBoundFieldNumber'
    })
  });
};
exports.RangeSliderButton = RangeSliderButton;