"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlsPlugin = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _ = require(".");
var _options_list = require("./options_list");
var _range_slider = require("./range_slider");
var _time_slider = require("./time_slider");
var _controls_service = require("./services/controls/controls_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class ControlsPlugin {
  async startControlsKibanaServices(coreStart, startPlugins) {
    const {
      registry,
      pluginServices
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/plugin_services')));
    pluginServices.setRegistry(registry.start({
      coreStart,
      startPlugins
    }));
  }
  transferEditorFunctions(factoryDef, factory) {
    var _factoryDef$controlEd;
    factory.controlEditorOptionsComponent = (_factoryDef$controlEd = factoryDef.controlEditorOptionsComponent) !== null && _factoryDef$controlEd !== void 0 ? _factoryDef$controlEd : undefined;
    factory.presaveTransformFunction = factoryDef.presaveTransformFunction;
    factory.isFieldCompatible = factoryDef.isFieldCompatible;
  }
  setup(_coreSetup, _setupPlugins) {
    const {
      registerControlType
    } = _controls_service.controlsService;
    const {
      embeddable
    } = _setupPlugins;

    // register control group embeddable factory
    _coreSetup.getStartServices().then(([, deps]) => {
      embeddable.registerEmbeddableFactory(_.CONTROL_GROUP_TYPE, new _.ControlGroupContainerFactory(deps.embeddable));

      // Options List control factory setup
      const optionsListFactoryDef = new _options_list.OptionsListEmbeddableFactory();
      const optionsListFactory = embeddable.registerEmbeddableFactory(_.OPTIONS_LIST_CONTROL, optionsListFactoryDef)();
      this.transferEditorFunctions(optionsListFactoryDef, optionsListFactory);
      registerControlType(optionsListFactory);

      // Register range slider
      const rangeSliderFactoryDef = new _range_slider.RangeSliderEmbeddableFactory();
      const rangeSliderFactory = embeddable.registerEmbeddableFactory(_.RANGE_SLIDER_CONTROL, rangeSliderFactoryDef)();
      this.transferEditorFunctions(rangeSliderFactoryDef, rangeSliderFactory);
      registerControlType(rangeSliderFactory);
      const timeSliderFactoryDef = new _time_slider.TimeSliderEmbeddableFactory();
      const timeSliderFactory = embeddable.registerEmbeddableFactory(_.TIME_SLIDER_CONTROL, timeSliderFactoryDef)();
      this.transferEditorFunctions(timeSliderFactoryDef, timeSliderFactory);
      registerControlType(timeSliderFactory);
    });
    return {
      registerControlType
    };
  }
  start(coreStart, startPlugins) {
    this.startControlsKibanaServices(coreStart, startPlugins).then(async () => {
      const {
        uiActions
      } = startPlugins;
      const {
        DeleteControlAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./control_group/actions/delete_control_action')));
      const deleteControlAction = new DeleteControlAction();
      uiActions.registerAction(deleteControlAction);
      uiActions.attachAction(_public.PANEL_HOVER_TRIGGER, deleteControlAction.id);
      const {
        EditControlAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./control_group/actions/edit_control_action')));
      const editControlAction = new EditControlAction(deleteControlAction);
      uiActions.registerAction(editControlAction);
      uiActions.attachAction(_public.PANEL_HOVER_TRIGGER, editControlAction.id);
      const {
        ClearControlAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./control_group/actions/clear_control_action')));
      const clearControlAction = new ClearControlAction();
      uiActions.registerAction(clearControlAction);
      uiActions.attachAction(_public.PANEL_HOVER_TRIGGER, clearControlAction.id);
    });
    const {
      getControlFactory,
      getControlTypes
    } = _controls_service.controlsService;
    return {
      getControlFactory,
      getControlTypes
    };
  }
  stop() {}
}
exports.ControlsPlugin = ControlsPlugin;