"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListStrings = {
  control: {
    getSeparator: () => _i18n.i18n.translate('controls.optionsList.control.separator', {
      defaultMessage: ', '
    }),
    getPlaceholder: () => _i18n.i18n.translate('controls.optionsList.control.placeholder', {
      defaultMessage: 'Any'
    }),
    getNegate: () => _i18n.i18n.translate('controls.optionsList.control.negate', {
      defaultMessage: 'NOT'
    }),
    getExcludeExists: () => _i18n.i18n.translate('controls.optionsList.control.excludeExists', {
      defaultMessage: 'DOES NOT'
    })
  },
  editor: {
    getSelectionOptionsTitle: () => _i18n.i18n.translate('controls.optionsList.editor.selectionOptionsTitle', {
      defaultMessage: 'Selections'
    }),
    selectionTypes: {
      multi: {
        getLabel: () => _i18n.i18n.translate('controls.optionsList.editor.multiSelectLabel', {
          defaultMessage: 'Allow  multiple selections'
        })
      },
      single: {
        getLabel: () => _i18n.i18n.translate('controls.optionsList.editor.singleSelectLabel', {
          defaultMessage: 'Only allow a single selection'
        })
      }
    },
    getSearchOptionsTitle: () => _i18n.i18n.translate('controls.optionsList.editor.searchOptionsTitle', {
      defaultMessage: `Searching`
    }),
    searchTypes: {
      prefix: {
        getLabel: () => _i18n.i18n.translate('controls.optionsList.editor.prefixSearchLabel', {
          defaultMessage: 'Prefix'
        }),
        getTooltip: () => _i18n.i18n.translate('controls.optionsList.editor.prefixSearchTooltip', {
          defaultMessage: 'Matches values that begin with the given search string.'
        })
      },
      wildcard: {
        getLabel: () => _i18n.i18n.translate('controls.optionsList.editor.wildcardSearchLabel', {
          defaultMessage: 'Contains'
        }),
        getTooltip: () => _i18n.i18n.translate('controls.optionsList.editor.wildcardSearchTooltip', {
          defaultMessage: 'Matches values that contain the given search string. Results might take longer to populate.'
        })
      }
    },
    getAdditionalSettingsTitle: () => _i18n.i18n.translate('controls.optionsList.editor.additionalSettingsTitle', {
      defaultMessage: `Additional settings`
    }),
    getRunPastTimeoutTitle: () => _i18n.i18n.translate('controls.optionsList.editor.runPastTimeout', {
      defaultMessage: 'Ignore timeout for results'
    }),
    getRunPastTimeoutTooltip: () => _i18n.i18n.translate('controls.optionsList.editor.runPastTimeout.tooltip', {
      defaultMessage: 'Wait to display results until the list is complete. This setting is useful for large data sets, but the results might take longer to populate.'
    })
  },
  popover: {
    getAriaLabel: fieldName => _i18n.i18n.translate('controls.optionsList.popover.ariaLabel', {
      defaultMessage: 'Popover for {fieldName} control',
      values: {
        fieldName
      }
    }),
    getSuggestionsAriaLabel: (fieldName, optionCount) => _i18n.i18n.translate('controls.optionsList.popover.suggestionsAriaLabel', {
      defaultMessage: 'Available {optionCount, plural, one {option} other {options}} for {fieldName}',
      values: {
        fieldName,
        optionCount
      }
    }),
    getAllowExpensiveQueriesWarning: () => _i18n.i18n.translate('controls.optionsList.popover.allowExpensiveQueriesWarning', {
      defaultMessage: 'The cluster setting to allow expensive queries is off, so some features are disabled.'
    }),
    getLoadingMoreMessage: () => _i18n.i18n.translate('controls.optionsList.popover.loadingMore', {
      defaultMessage: 'Loading more options...'
    }),
    getAtEndOfOptionsMessage: () => _i18n.i18n.translate('controls.optionsList.popover.endOfOptions', {
      defaultMessage: 'The top 1,000 available options are displayed. View more options by searching for the name.'
    }),
    getEmptyMessage: () => _i18n.i18n.translate('controls.optionsList.popover.empty', {
      defaultMessage: 'No options found'
    }),
    getSelectionsEmptyMessage: () => _i18n.i18n.translate('controls.optionsList.popover.selectionsEmpty', {
      defaultMessage: 'You have no selections'
    }),
    getAllOptionsButtonTitle: () => _i18n.i18n.translate('controls.optionsList.popover.allOptionsTitle', {
      defaultMessage: 'Show all options'
    }),
    getSelectedOptionsButtonTitle: () => _i18n.i18n.translate('controls.optionsList.popover.selectedOptionsTitle', {
      defaultMessage: 'Show only selected options'
    }),
    searchPlaceholder: {
      prefix: {
        getPlaceholderText: () => _i18n.i18n.translate('controls.optionsList.popover.prefixSearchPlaceholder', {
          defaultMessage: 'Starts with...'
        })
      },
      wildcard: {
        getPlaceholderText: () => _i18n.i18n.translate('controls.optionsList.popover.wildcardSearchPlaceholder', {
          defaultMessage: 'Contains...'
        })
      }
    },
    getCardinalityLabel: totalOptions => _i18n.i18n.translate('controls.optionsList.popover.cardinalityLabel', {
      defaultMessage: '{totalOptions, number} {totalOptions, plural, one {option} other {options}}',
      values: {
        totalOptions
      }
    }),
    getInvalidSelectionsSectionAriaLabel: (fieldName, invalidSelectionCount) => _i18n.i18n.translate('controls.optionsList.popover.invalidSelectionsAriaLabel', {
      defaultMessage: 'Ignored {invalidSelectionCount, plural, one {selection} other {selections}} for {fieldName}',
      values: {
        fieldName,
        invalidSelectionCount
      }
    }),
    getInvalidSelectionsSectionTitle: invalidSelectionCount => _i18n.i18n.translate('controls.optionsList.popover.invalidSelectionsSectionTitle', {
      defaultMessage: 'Ignored {invalidSelectionCount, plural, one {selection} other {selections}}',
      values: {
        invalidSelectionCount
      }
    }),
    getInvalidSelectionsLabel: selectedOptions => _i18n.i18n.translate('controls.optionsList.popover.invalidSelectionsLabel', {
      defaultMessage: '{selectedOptions} {selectedOptions, plural, one {selection} other {selections}} ignored',
      values: {
        selectedOptions
      }
    }),
    getInvalidSelectionScreenReaderText: () => _i18n.i18n.translate('controls.optionsList.popover.invalidSelectionScreenReaderText', {
      defaultMessage: 'Invalid selection.'
    }),
    getIncludeLabel: () => _i18n.i18n.translate('controls.optionsList.popover.includeLabel', {
      defaultMessage: 'Include'
    }),
    getExcludeLabel: () => _i18n.i18n.translate('controls.optionsList.popover.excludeLabel', {
      defaultMessage: 'Exclude'
    }),
    getIncludeExcludeLegend: () => _i18n.i18n.translate('controls.optionsList.popover.excludeOptionsLegend', {
      defaultMessage: 'Include or exclude selections'
    }),
    getSortPopoverTitle: () => _i18n.i18n.translate('controls.optionsList.popover.sortTitle', {
      defaultMessage: 'Sort'
    }),
    getSortPopoverDescription: () => _i18n.i18n.translate('controls.optionsList.popover.sortDescription', {
      defaultMessage: 'Define the sort order'
    }),
    getSortDisabledTooltip: () => _i18n.i18n.translate('controls.optionsList.popover.sortDisabledTooltip', {
      defaultMessage: 'Sorting is ignored when “Show only selected” is true'
    }),
    getDocumentCountTooltip: documentCount => _i18n.i18n.translate('controls.optionsList.popover.documentCountTooltip', {
      defaultMessage: 'This value appears in {documentCount, number} {documentCount, plural, one {document} other {documents}}',
      values: {
        documentCount
      }
    }),
    getDocumentCountScreenReaderText: documentCount => _i18n.i18n.translate('controls.optionsList.popover.documentCountScreenReaderText', {
      defaultMessage: 'Appears in {documentCount, number} {documentCount, plural, one {document} other {documents}}',
      values: {
        documentCount
      }
    })
  },
  controlAndPopover: {
    getExists: (negate = +false) => _i18n.i18n.translate('controls.optionsList.controlAndPopover.exists', {
      defaultMessage: '{negate, plural, one {Exist} other {Exists}}',
      values: {
        negate
      }
    })
  },
  editorAndPopover: {
    getSortDirectionLegend: () => _i18n.i18n.translate('controls.optionsList.popover.sortDirections', {
      defaultMessage: 'Sort directions'
    }),
    sortBy: {
      _count: {
        getSortByLabel: () => _i18n.i18n.translate('controls.optionsList.popover.sortBy.docCount', {
          defaultMessage: 'By document count'
        })
      },
      _key: {
        getSortByLabel: () => _i18n.i18n.translate('controls.optionsList.popover.sortBy.alphabetical', {
          defaultMessage: 'Alphabetically'
        })
      }
    },
    sortOrder: {
      asc: {
        getSortOrderLabel: () => _i18n.i18n.translate('controls.optionsList.popover.sortOrder.asc', {
          defaultMessage: 'Ascending'
        })
      },
      desc: {
        getSortOrderLabel: () => _i18n.i18n.translate('controls.optionsList.popover.sortOrder.desc', {
          defaultMessage: 'Descending'
        })
      }
    }
  }
};
exports.OptionsListStrings = OptionsListStrings;