"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverActionBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _options_list_strings = require("./options_list_strings");
var _options_list_embeddable = require("../embeddable/options_list_embeddable");
var _options_list_popover_sorting_button = require("./options_list_popover_sorting_button");
var _types = require("../../../common/options_list/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListPopoverActionBar = ({
  showOnlySelected,
  updateSearchString,
  setShowOnlySelected
}) => {
  var _optionsList$select;
  const optionsList = (0, _options_list_embeddable.useOptionsList)();
  const totalCardinality = (_optionsList$select = optionsList.select(state => state.componentState.totalCardinality)) !== null && _optionsList$select !== void 0 ? _optionsList$select : 0;
  const searchString = optionsList.select(state => state.componentState.searchString);
  const invalidSelections = optionsList.select(state => state.componentState.invalidSelections);
  const searchTechnique = optionsList.select(state => state.explicitInput.searchTechnique);
  const allowExpensiveQueries = optionsList.select(state => state.componentState.allowExpensiveQueries);
  const hideSort = optionsList.select(state => state.explicitInput.hideSort);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "optionsList__actions"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    isInvalid: !searchString.valid,
    compressed: true,
    disabled: showOnlySelected,
    fullWidth: true,
    onChange: event => updateSearchString(event.target.value),
    value: searchString.value,
    "data-test-subj": "optionsList-control-search-input",
    placeholder: _options_list_strings.OptionsListStrings.popover.searchPlaceholder[searchTechnique !== null && searchTechnique !== void 0 ? searchTechnique : _types.OPTIONS_LIST_DEFAULT_SEARCH_TECHNIQUE].getPlaceholderText()
  })), !hideSort && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover_sorting_button.OptionsListPopoverSortingButton, {
    showOnlySelected: showOnlySelected
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    className: "optionsList__actionsRow",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, allowExpensiveQueries && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    "data-test-subj": "optionsList-cardinality-label"
  }, _options_list_strings.OptionsListStrings.popover.getCardinalityLabel(totalCardinality))), invalidSelections && invalidSelections.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, allowExpensiveQueries && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "optionsList__actionBarDivider"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _options_list_strings.OptionsListStrings.popover.getInvalidSelectionsLabel(invalidSelections.length)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: showOnlySelected ? _options_list_strings.OptionsListStrings.popover.getAllOptionsButtonTitle() : _options_list_strings.OptionsListStrings.popover.getSelectedOptionsButtonTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "list",
    "aria-pressed": showOnlySelected,
    color: showOnlySelected ? 'primary' : 'text',
    display: showOnlySelected ? 'base' : 'empty',
    onClick: () => setShowOnlySelected(!showOnlySelected),
    "data-test-subj": "optionsList-control-show-only-selected",
    "aria-label": showOnlySelected ? _options_list_strings.OptionsListStrings.popover.getAllOptionsButtonTitle() : _options_list_strings.OptionsListStrings.popover.getSelectedOptionsButtonTitle()
  }))))))));
};
exports.OptionsListPopoverActionBar = OptionsListPopoverActionBar;