"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _options_list_strings = require("./options_list_strings");
var _options_list_popover_title = require("./options_list_popover_title");
var _options_list_popover_footer = require("./options_list_popover_footer");
var _options_list_popover_action_bar = require("./options_list_popover_action_bar");
var _options_list_popover_suggestions = require("./options_list_popover_suggestions");
var _options_list_popover_invalid_selections = require("./options_list_popover_invalid_selections");
var _options_list_embeddable = require("../embeddable/options_list_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListPopover = ({
  width,
  isLoading,
  updateSearchString,
  loadMoreSuggestions
}) => {
  const optionsList = (0, _options_list_embeddable.useOptionsList)();
  const field = optionsList.select(state => state.componentState.field);
  const availableOptions = optionsList.select(state => state.componentState.availableOptions);
  const invalidSelections = optionsList.select(state => state.componentState.invalidSelections);
  const id = optionsList.select(state => state.explicitInput.id);
  const fieldName = optionsList.select(state => state.explicitInput.fieldName);
  const hideExclude = optionsList.select(state => state.explicitInput.hideExclude);
  const hideActionBar = optionsList.select(state => state.explicitInput.hideActionBar);
  const [showOnlySelected, setShowOnlySelected] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    id: `control-popover-${id}`,
    style: {
      width,
      minWidth: 300
    },
    "data-test-subj": `optionsList-control-popover`,
    "aria-label": _options_list_strings.OptionsListStrings.popover.getAriaLabel(fieldName)
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover_title.OptionsListPopoverTitle, null), (field === null || field === void 0 ? void 0 : field.type) !== 'boolean' && !hideActionBar && /*#__PURE__*/_react.default.createElement(_options_list_popover_action_bar.OptionsListPopoverActionBar, {
    showOnlySelected: showOnlySelected,
    updateSearchString: updateSearchString,
    setShowOnlySelected: setShowOnlySelected
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `optionsList-control-available-options`,
    "data-option-count": isLoading ? 0 : Object.keys(availableOptions !== null && availableOptions !== void 0 ? availableOptions : {}).length,
    style: {
      width: '100%',
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover_suggestions.OptionsListPopoverSuggestions, {
    loadMoreSuggestions: loadMoreSuggestions,
    showOnlySelected: showOnlySelected
  }), !showOnlySelected && invalidSelections && !(0, _lodash.isEmpty)(invalidSelections) && /*#__PURE__*/_react.default.createElement(_options_list_popover_invalid_selections.OptionsListPopoverInvalidSelections, null)), !hideExclude && /*#__PURE__*/_react.default.createElement(_options_list_popover_footer.OptionsListPopoverFooter, {
    isLoading: isLoading
  })));
};
exports.OptionsListPopover = OptionsListPopover;