"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListEditorOptions = void 0;
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _services = require("../../services");
var _suggestions_sorting = require("../../../common/options_list/suggestions_sorting");
var _options_list_strings = require("./options_list_strings");
var _types = require("../../../common/options_list/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TooltipText = ({
  label,
  tooltip
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "xs",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  css: (0, _react2.css)`
        margin-top: 0px !important;
      `
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: tooltip,
  position: "right"
})));
const selectionOptions = [{
  id: 'multi',
  label: _options_list_strings.OptionsListStrings.editor.selectionTypes.multi.getLabel(),
  'data-test-subj': 'optionsListControl__multiSearchOptionAdditionalSetting'
}, {
  id: 'single',
  label: _options_list_strings.OptionsListStrings.editor.selectionTypes.single.getLabel(),
  'data-test-subj': 'optionsListControl__singleSearchOptionAdditionalSetting'
}];
const searchOptions = [{
  id: 'prefix',
  label: /*#__PURE__*/_react.default.createElement(TooltipText, {
    label: _options_list_strings.OptionsListStrings.editor.searchTypes.prefix.getLabel(),
    tooltip: _options_list_strings.OptionsListStrings.editor.searchTypes.prefix.getTooltip()
  }),
  'data-test-subj': 'optionsListControl__prefixSearchOptionAdditionalSetting'
}, {
  id: 'wildcard',
  label: /*#__PURE__*/_react.default.createElement(TooltipText, {
    label: _options_list_strings.OptionsListStrings.editor.searchTypes.wildcard.getLabel(),
    tooltip: _options_list_strings.OptionsListStrings.editor.searchTypes.wildcard.getTooltip()
  }),
  'data-test-subj': 'optionsListControl__wildcardSearchOptionAdditionalSetting'
}];
const OptionsListEditorOptions = ({
  initialInput,
  onChange,
  fieldType
}) => {
  var _initialInput$sort$di, _initialInput$sort, _initialInput$sort$by, _initialInput$sort2, _state$searchTechniqu;
  const [state, setState] = (0, _react.useState)({
    sortDirection: (_initialInput$sort$di = initialInput === null || initialInput === void 0 ? void 0 : (_initialInput$sort = initialInput.sort) === null || _initialInput$sort === void 0 ? void 0 : _initialInput$sort.direction) !== null && _initialInput$sort$di !== void 0 ? _initialInput$sort$di : _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.direction,
    sortBy: (_initialInput$sort$by = initialInput === null || initialInput === void 0 ? void 0 : (_initialInput$sort2 = initialInput.sort) === null || _initialInput$sort2 === void 0 ? void 0 : _initialInput$sort2.by) !== null && _initialInput$sort$by !== void 0 ? _initialInput$sort$by : _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.by,
    searchTechnique: initialInput === null || initialInput === void 0 ? void 0 : initialInput.searchTechnique,
    runPastTimeout: initialInput === null || initialInput === void 0 ? void 0 : initialInput.runPastTimeout,
    singleSelect: initialInput === null || initialInput === void 0 ? void 0 : initialInput.singleSelect,
    hideExclude: initialInput === null || initialInput === void 0 ? void 0 : initialInput.hideExclude,
    hideExists: initialInput === null || initialInput === void 0 ? void 0 : initialInput.hideExists,
    hideSort: initialInput === null || initialInput === void 0 ? void 0 : initialInput.hideSort
  });
  const {
    loading: waitingForAllowExpensiveQueries,
    value: allowExpensiveQueries
  } = (0, _useAsync.default)(async () => {
    const {
      optionsList: optionsListService
    } = _services.pluginServices.getServices();
    return optionsListService.getAllowExpensiveQueries();
  }, []);
  (0, _react.useEffect)(() => {
    // when field type changes, ensure that the selected sort type is still valid
    if (!(0, _suggestions_sorting.getCompatibleSortingTypes)(fieldType).includes(state.sortBy)) {
      onChange({
        sort: _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT
      });
      setState(s => ({
        ...s,
        sortBy: _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.by,
        sortDirection: _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.direction
      }));
    }
  }, [fieldType, onChange, state.sortBy]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _options_list_strings.OptionsListStrings.editor.getSelectionOptionsTitle(),
    "data-test-subj": "optionsListControl__selectionOptionsRadioGroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: selectionOptions,
    idSelected: state.singleSelect ? 'single' : 'multi',
    onChange: id => {
      const newSingleSelect = id === 'single';
      onChange({
        singleSelect: newSingleSelect
      });
      setState(s => ({
        ...s,
        singleSelect: newSingleSelect
      }));
    }
  })), waitingForAllowExpensiveQueries ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  })) : allowExpensiveQueries && fieldType !== 'ip' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _options_list_strings.OptionsListStrings.editor.getSearchOptionsTitle(),
    "data-test-subj": "optionsListControl__searchOptionsRadioGroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: searchOptions,
    idSelected: (_state$searchTechniqu = state.searchTechnique) !== null && _state$searchTechniqu !== void 0 ? _state$searchTechniqu : _types.OPTIONS_LIST_DEFAULT_SEARCH_TECHNIQUE,
    onChange: id => {
      const searchTechnique = id;
      onChange({
        searchTechnique
      });
      setState(s => ({
        ...s,
        searchTechnique
      }));
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _options_list_strings.OptionsListStrings.editor.getAdditionalSettingsTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(TooltipText, {
      label: _options_list_strings.OptionsListStrings.editor.getRunPastTimeoutTitle(),
      tooltip: _options_list_strings.OptionsListStrings.editor.getRunPastTimeoutTooltip()
    }),
    checked: Boolean(state.runPastTimeout),
    onChange: () => {
      onChange({
        runPastTimeout: !state.runPastTimeout
      });
      setState(s => ({
        ...s,
        runPastTimeout: !s.runPastTimeout
      }));
    },
    "data-test-subj": 'optionsListControl__runPastTimeoutAdditionalSetting'
  })));
};
exports.OptionsListEditorOptions = OptionsListEditorOptions;