"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isControlGroup = exports.getNextPanelOrder = exports.getCompatibleControlType = void 0;
var _data_control_editor_tools = require("../editor/data_control_editor_tools");
var _services = require("../../services");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getNextPanelOrder = panels => {
  let nextOrder = 0;
  if (Object.keys(panels !== null && panels !== void 0 ? panels : {}).length > 0) {
    nextOrder = Object.values(panels !== null && panels !== void 0 ? panels : {}).reduce((highestSoFar, panel) => {
      if (panel.order > highestSoFar) highestSoFar = panel.order;
      return highestSoFar;
    }, 0) + 1;
  }
  return nextOrder;
};
exports.getNextPanelOrder = getNextPanelOrder;
const getCompatibleControlType = async ({
  dataViewId,
  fieldName
}) => {
  const dataView = await _services.pluginServices.getServices().dataViews.get(dataViewId);
  const fieldRegistry = await (0, _data_control_editor_tools.getDataControlFieldRegistry)(dataView);
  const field = fieldRegistry[fieldName];
  return field.compatibleControlTypes[0];
};
exports.getCompatibleControlType = getCompatibleControlType;
const isControlGroup = embeddable => {
  return embeddable.isContainer && embeddable.type === _types.CONTROL_GROUP_TYPE;
};
exports.isControlGroup = isControlGroup;