"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroupContainerFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/presentation-util-plugin/public");
var _types = require("../types");
var _control_group_persistable_state = require("../../../common/control_group/control_group_persistable_state");
var _common = require("../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class ControlGroupContainerFactory {
  constructor(persistableStateService) {
    (0, _defineProperty2.default)(this, "isContainerType", true);
    (0, _defineProperty2.default)(this, "type", _types.CONTROL_GROUP_TYPE);
    (0, _defineProperty2.default)(this, "inject", void 0);
    (0, _defineProperty2.default)(this, "extract", void 0);
    (0, _defineProperty2.default)(this, "isEditable", async () => false);
    (0, _defineProperty2.default)(this, "getDisplayName", () => {
      return _i18n.i18n.translate('controls.controlGroup.title', {
        defaultMessage: 'Control group'
      });
    });
    (0, _defineProperty2.default)(this, "create", async (initialInput, parent, settings, fieldFilterPredicate) => {
      const reduxEmbeddablePackage = await (0, _public.lazyLoadReduxToolsPackage)();
      const {
        ControlGroupContainer
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./control_group_container')));
      return new ControlGroupContainer(reduxEmbeddablePackage, initialInput, parent, settings, fieldFilterPredicate);
    });
    this.persistableStateService = persistableStateService;
    this.inject = (0, _control_group_persistable_state.createControlGroupInject)(this.persistableStateService);
    this.extract = (0, _control_group_persistable_state.createControlGroupExtract)(this.persistableStateService);
  }
  getDefaultInput() {
    return (0, _common.getDefaultControlGroupInput)();
  }
}
exports.ControlGroupContainerFactory = ControlGroupContainerFactory;