"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.search = void 0;
var _schemas = require("../../../common/schemas");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const search = {
  schemas: _schemas.rpcSchemas.search,
  fn: async (ctx, {
    contentTypeId,
    version,
    query,
    options
  }) => {
    const storageContext = (0, _utils.getStorageContext)({
      contentTypeId,
      version,
      ctx
    });
    const crudInstance = ctx.contentRegistry.getCrud(contentTypeId);
    return crudInstance.search(storageContext, query, options);
  }
};
exports.search = search;