"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTypes = getTypes;
var _lodash = _interopRequireDefault(require("lodash"));
var _services = require("../../services");
var _expand_aliases = require("./expand_aliases");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getTypes(indices) {
  let ret = [];
  const perIndexTypes = (0, _services.getAutocompleteInfo)().mapping.perIndexTypes;
  indices = (0, _expand_aliases.expandAliases)(indices);
  if (typeof indices === 'string') {
    const typeDict = perIndexTypes[indices];
    if (!typeDict) {
      return [];
    }

    // filter what we need
    if (Array.isArray(typeDict)) {
      typeDict.forEach(type => {
        ret.push(type);
      });
    } else if (typeof typeDict === 'object') {
      Object.keys(typeDict).forEach(type => {
        ret.push(type);
      });
    }
  } else {
    // multi index mode.
    Object.keys(perIndexTypes).forEach(index => {
      if (!indices || indices.includes(index)) {
        ret.push(getTypes(index));
      }
    });
    ret = [].concat.apply([], ret);
  }
  return _lodash.default.uniq(ret);
}