"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlParams = exports.ParamComponent = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _components = require("./components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ParamComponent extends _components.ConstantComponent {
  constructor(name, parent, description) {
    super(name, parent);
    this.description = description;
  }
  getTerms() {
    const t = {
      name: this.name
    };
    if (this.description === '__flag__') {
      t.meta = 'flag';
    } else {
      t.meta = 'param';
      t.insertValue = this.name + '=';
    }
    return [t];
  }
}
exports.ParamComponent = ParamComponent;
class UrlParams {
  constructor(description, defaults) {
    // This is not really a component, just a handy container to make iteration logic simpler
    this.rootComponent = new _components.SharedComponent('ROOT');
    if (_lodash.default.isUndefined(defaults)) {
      defaults = {
        pretty: '__flag__',
        format: ['json', 'yaml'],
        filter_path: ''
      };
    }
    description = _lodash.default.clone(description || {});
    _lodash.default.defaults(description, defaults);
    _lodash.default.each(description, (pDescription, param) => {
      const component = new ParamComponent(param, this.rootComponent, pDescription);
      if (Array.isArray(pDescription)) {
        new _components.ListComponent(param, pDescription, component);
      } else if (pDescription === '__flag__') {
        new _components.ListComponent(param, ['true', 'false'], component);
      }
    });
  }
  getTopLevelComponents() {
    return this.rootComponent.next;
  }
}
exports.UrlParams = UrlParams;