"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistoryViewer = HistoryViewer;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _subscribe_console_resize_checker = require("../editor/legacy/subscribe_console_resize_checker");
var InputMode = _interopRequireWildcard(require("../../models/legacy_core_editor/mode/input"));
var editor = _interopRequireWildcard(require("../../models/legacy_core_editor"));
var _apply_editor_settings = require("../editor/legacy/console_editor/apply_editor_settings");
var _utils = require("../../../lib/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const inputMode = new InputMode.Mode();
function HistoryViewer({
  settings,
  req
}) {
  const divRef = (0, _react.useRef)(null);
  const viewerRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    const viewer = editor.createReadOnlyAceEditor(divRef.current);
    viewerRef.current = viewer;
    const unsubscribe = (0, _subscribe_console_resize_checker.subscribeResizeChecker)(divRef.current, viewer);
    return () => unsubscribe();
  }, []);
  (0, _react.useEffect)(() => {
    (0, _apply_editor_settings.applyCurrentSettings)(viewerRef.current, settings);
  }, [settings]);
  if (viewerRef.current) {
    const {
      current: viewer
    } = viewerRef;
    if (req) {
      const indent = true;
      const formattedData = req.data ? (0, _utils.formatRequestBodyDoc)([req.data], indent).data : '';
      const s = req.method + ' ' + req.endpoint + '\n' + formattedData;
      viewer.update(s, inputMode);
      viewer.clearSelection();
    } else {
      viewer.update(_i18n.i18n.translate('console.historyPage.noHistoryTextMessage', {
        defaultMessage: 'No history available'
      }), inputMode);
    }
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "conHistory__viewer",
    ref: divRef
  });
}