"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageQuotaError = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const StorageQuotaError = ({
  onClearHistory,
  onDisableSavingToHistory
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  onClick: onClearHistory
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "console.notification.clearHistory",
  defaultMessage: "Clear history"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  onClick: onDisableSavingToHistory
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "console.notification.disableSavingToHistory",
  defaultMessage: "Disable saving"
}))));
exports.StorageQuotaError = StorageQuotaError;