"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInstallationStats = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _services = require("@kbn/fleet-plugin/server/services");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInstallationStats = async (esClient, soClient, coreServices, logger) => {
  const [, cspServerPluginStartDeps] = await coreServices;
  const cspContext = {
    logger,
    esClient,
    soClient,
    agentPolicyService: cspServerPluginStartDeps.fleet.agentPolicyService,
    packagePolicyService: cspServerPluginStartDeps.fleet.packagePolicyService,
    isPluginInitialized
  };
  const getInstalledPackagePolicies = async (packagePolicies, agentPolicies) => {
    const installationStats = await packagePolicies.map(packagePolicy => {
      var _agentPolicies$find$a, _agentPolicies$find, _packagePolicy$vars, _packagePolicy$vars$p, _packagePolicy$vars2, _packagePolicy$vars2$, _packagePolicy$packag;
      const agentCounts = (_agentPolicies$find$a = agentPolicies === null || agentPolicies === void 0 ? void 0 : (_agentPolicies$find = agentPolicies.find(agentPolicy => (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id) === packagePolicy.policy_id)) === null || _agentPolicies$find === void 0 ? void 0 : _agentPolicies$find.agents) !== null && _agentPolicies$find$a !== void 0 ? _agentPolicies$find$a : 0;
      return {
        package_policy_id: packagePolicy.id,
        feature: (_packagePolicy$vars = packagePolicy.vars) === null || _packagePolicy$vars === void 0 ? void 0 : (_packagePolicy$vars$p = _packagePolicy$vars.posture) === null || _packagePolicy$vars$p === void 0 ? void 0 : _packagePolicy$vars$p.value,
        deployment_mode: (_packagePolicy$vars2 = packagePolicy.vars) === null || _packagePolicy$vars2 === void 0 ? void 0 : (_packagePolicy$vars2$ = _packagePolicy$vars2.deployment) === null || _packagePolicy$vars2$ === void 0 ? void 0 : _packagePolicy$vars2$.value,
        package_version: (_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.version,
        created_at: packagePolicy.created_at,
        agent_policy_id: packagePolicy.policy_id,
        agent_count: agentCounts
      };
    });
    return installationStats;
  };
  const packagePolicies = await cspContext.packagePolicyService.list(soClient, {
    perPage: _common.SO_SEARCH_LIMIT,
    kuery: `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:"${_constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME}"`
  });
  const agentPolicies = await _services.agentPolicyService.list(soClient, {
    perPage: _common.SO_SEARCH_LIMIT,
    kuery: '',
    esClient,
    withAgentCount: true
  });
  if (!packagePolicies) return [];
  const installationStats = await getInstalledPackagePolicies(packagePolicies.items, (agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.items) || []);
  return installationStats;
};
exports.getInstallationStats = getInstallationStats;
const isPluginInitialized = () => {
  return true;
};