"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.vulnerabilitiesColumns = exports.getVulnerabilitiesColumnsGrid = void 0;
var _i18n = require("@kbn/i18n");
var _custom_sort_script = require("./utils/custom_sort_script");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const vulnerabilitiesColumns = {
  actions: 'actions',
  vulnerability: 'vulnerability.id',
  cvss: 'vulnerability.score.base',
  resource: 'resource.name',
  severity: 'vulnerability.severity',
  package: 'vulnerability.package.name',
  version: 'vulnerability.package.version',
  fix_version: 'vulnerability.package.fixed_version'
};
exports.vulnerabilitiesColumns = vulnerabilitiesColumns;
const defaultColumnProps = () => ({
  isExpandable: false,
  actions: {
    showHide: false,
    showMoveLeft: false,
    showMoveRight: false
  }
});
const getVulnerabilitiesColumnsGrid = cellActions => [{
  ...defaultColumnProps(),
  id: vulnerabilitiesColumns.actions,
  initialWidth: 40,
  display: [],
  actions: false,
  isSortable: false,
  isResizable: false,
  cellActions: []
}, {
  ...defaultColumnProps(),
  id: vulnerabilitiesColumns.vulnerability,
  displayAsText: _i18n.i18n.translate('xpack.csp.vulnerabilityTable.column.vulnerability', {
    defaultMessage: 'Vulnerability'
  }),
  initialWidth: 130,
  cellActions
}, {
  ...defaultColumnProps(),
  id: vulnerabilitiesColumns.cvss,
  displayAsText: 'CVSS',
  initialWidth: 80,
  isResizable: false,
  cellActions
}, {
  ...defaultColumnProps(),
  id: vulnerabilitiesColumns.resource,
  displayAsText: _i18n.i18n.translate('xpack.csp.vulnerabilityTable.column.resource', {
    defaultMessage: 'Resource'
  }),
  cellActions
}, {
  ...defaultColumnProps(),
  id: vulnerabilitiesColumns.severity,
  displayAsText: _i18n.i18n.translate('xpack.csp.vulnerabilityTable.column.severity', {
    defaultMessage: 'Severity'
  }),
  initialWidth: 100,
  cellActions,
  schema: _custom_sort_script.severitySchemaConfig.type
}, {
  ...defaultColumnProps(),
  id: vulnerabilitiesColumns.package,
  displayAsText: _i18n.i18n.translate('xpack.csp.vulnerabilityTable.column.package', {
    defaultMessage: 'Package'
  }),
  cellActions
}, {
  ...defaultColumnProps(),
  id: vulnerabilitiesColumns.version,
  displayAsText: _i18n.i18n.translate('xpack.csp.vulnerabilityTable.column.version', {
    defaultMessage: 'Version'
  }),
  cellActions
}, {
  ...defaultColumnProps(),
  id: vulnerabilitiesColumns.fix_version,
  displayAsText: _i18n.i18n.translate('xpack.csp.vulnerabilityTable.column.fixVersion', {
    defaultMessage: 'Fix Version'
  }),
  cellActions
}];
exports.getVulnerabilitiesColumnsGrid = getVulnerabilitiesColumnsGrid;