"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVulnerabilitiesGridCellActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_filters = require("./get_filters");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getVulnerabilitiesGridCellActions = ({
  data,
  columns,
  columnGridFn,
  pageSize,
  setUrlQuery,
  filters,
  dataView
}) => {
  const getColumnIdValue = (rowIndex, columnId) => {
    const vulnerabilityRow = data[rowIndex];
    if (!vulnerabilityRow) return null;
    if (columnId === columns.vulnerability) {
      var _vulnerabilityRow$vul;
      return (_vulnerabilityRow$vul = vulnerabilityRow.vulnerability) === null || _vulnerabilityRow$vul === void 0 ? void 0 : _vulnerabilityRow$vul.id;
    }
    if (columnId === columns.cvss) {
      var _vulnerabilityRow$vul2;
      return (_vulnerabilityRow$vul2 = vulnerabilityRow.vulnerability) === null || _vulnerabilityRow$vul2 === void 0 ? void 0 : _vulnerabilityRow$vul2.score.base;
    }
    if (columnId === columns.resource) {
      var _vulnerabilityRow$res;
      return (_vulnerabilityRow$res = vulnerabilityRow.resource) === null || _vulnerabilityRow$res === void 0 ? void 0 : _vulnerabilityRow$res.name;
    }
    if (columnId === columns.severity) {
      var _vulnerabilityRow$vul3;
      return (_vulnerabilityRow$vul3 = vulnerabilityRow.vulnerability) === null || _vulnerabilityRow$vul3 === void 0 ? void 0 : _vulnerabilityRow$vul3.severity;
    }
    if (columnId === columns.package) {
      var _vulnerabilityRow$vul4, _vulnerabilityRow$vul5;
      return (_vulnerabilityRow$vul4 = vulnerabilityRow.vulnerability) === null || _vulnerabilityRow$vul4 === void 0 ? void 0 : (_vulnerabilityRow$vul5 = _vulnerabilityRow$vul4.package) === null || _vulnerabilityRow$vul5 === void 0 ? void 0 : _vulnerabilityRow$vul5.name;
    }
    if (columnId === columns.version) {
      var _vulnerabilityRow$vul6, _vulnerabilityRow$vul7;
      return (_vulnerabilityRow$vul6 = vulnerabilityRow.vulnerability) === null || _vulnerabilityRow$vul6 === void 0 ? void 0 : (_vulnerabilityRow$vul7 = _vulnerabilityRow$vul6.package) === null || _vulnerabilityRow$vul7 === void 0 ? void 0 : _vulnerabilityRow$vul7.version;
    }
    if (columnId === columns.fix_version) {
      var _vulnerabilityRow$vul8, _vulnerabilityRow$vul9;
      return (_vulnerabilityRow$vul8 = vulnerabilityRow.vulnerability) === null || _vulnerabilityRow$vul8 === void 0 ? void 0 : (_vulnerabilityRow$vul9 = _vulnerabilityRow$vul8.package) === null || _vulnerabilityRow$vul9 === void 0 ? void 0 : _vulnerabilityRow$vul9.fixed_version;
    }
    if (columnId === columns.resource_id) {
      var _vulnerabilityRow$res2;
      return (_vulnerabilityRow$res2 = vulnerabilityRow.resource) === null || _vulnerabilityRow$res2 === void 0 ? void 0 : _vulnerabilityRow$res2.id;
    }
    if (columnId === columns.resource_name) {
      var _vulnerabilityRow$res3;
      return (_vulnerabilityRow$res3 = vulnerabilityRow.resource) === null || _vulnerabilityRow$res3 === void 0 ? void 0 : _vulnerabilityRow$res3.name;
    }
    if (columnId === columns.region) {
      var _vulnerabilityRow$clo;
      return (_vulnerabilityRow$clo = vulnerabilityRow.cloud) === null || _vulnerabilityRow$clo === void 0 ? void 0 : _vulnerabilityRow$clo.region;
    }
  };
  const cellActions = [({
    Component,
    rowIndex,
    columnId
  }) => {
    const rowIndexFromPage = rowIndex > pageSize - 1 ? rowIndex % pageSize : rowIndex;
    const value = getColumnIdValue(rowIndexFromPage, columnId);
    if (!value) return null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesTableCell.addFilterButtonTooltip', {
        defaultMessage: 'Add {columnId} filter',
        values: {
          columnId
        }
      })
    }, /*#__PURE__*/_react.default.createElement(Component, {
      iconType: "plusInCircle",
      "aria-label": _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesTableCell.addFilterButton', {
        defaultMessage: 'Add {columnId} filter',
        values: {
          columnId
        }
      }),
      onClick: () => {
        setUrlQuery({
          pageIndex: 0,
          filters: (0, _get_filters.getFilters)({
            filters,
            dataView,
            field: columnId,
            value,
            negate: false
          })
        });
      }
    }, _translations.FILTER_IN));
  }, ({
    Component,
    rowIndex,
    columnId
  }) => {
    const rowIndexFromPage = rowIndex > pageSize - 1 ? rowIndex % pageSize : rowIndex;
    const value = getColumnIdValue(rowIndexFromPage, columnId);
    if (!value) return null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesTableCell.addNegatedFilterButtonTooltip', {
        defaultMessage: 'Add {columnId} negated filter',
        values: {
          columnId
        }
      })
    }, /*#__PURE__*/_react.default.createElement(Component, {
      iconType: "minusInCircle",
      "aria-label": _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesTableCell.addNegateFilterButton', {
        defaultMessage: 'Add {columnId} negated filter',
        values: {
          columnId
        }
      }),
      onClick: () => {
        setUrlQuery({
          pageIndex: 0,
          filters: (0, _get_filters.getFilters)({
            filters,
            dataView,
            field: columnId,
            value,
            negate: true
          })
        });
      }
    }, _translations.FILTER_OUT));
  }];
  return columnGridFn(cellActions);
};
exports.getVulnerabilitiesGridCellActions = getVulnerabilitiesGridCellActions;