"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyTemplateVarsForm = exports.PolicyTemplateSelector = exports.PolicyTemplateInputSelector = exports.PolicyTemplateInfo = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
var _utils = require("./utils");
var _csp_boxed_radio_group = require("./csp_boxed_radio_group");
var _aws_credentials_form = require("./aws_credentials_form/aws_credentials_form");
var _eks_credentials_form = require("./eks_credentials_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPolicyTemplateLabel = policyTemplate => {
  if (policyTemplate === _constants.VULN_MGMT_POLICY_TEMPLATE) {
    return _constants.CNVM_POLICY_TEMPLATE.toUpperCase();
  }
  return policyTemplate.toUpperCase();
};
const PolicyTemplateSelector = ({
  policy,
  selectedTemplate,
  setPolicyTemplate,
  disabled
}) => {
  const policyTemplates = new Set(policy.inputs.map(input => input.policy_template));
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.selectIntegrationTypeTitle",
    defaultMessage: "Select the type of security posture management integration you want to configure"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_csp_boxed_radio_group.RadioGroup, {
    options: Array.from(policyTemplates, v => ({
      id: v,
      label: getPolicyTemplateLabel(v)
    })),
    idSelected: selectedTemplate,
    onChange: id => setPolicyTemplate(id),
    disabled: disabled
  }));
};
exports.PolicyTemplateSelector = PolicyTemplateSelector;
const PolicyTemplateVarsForm = ({
  input,
  ...props
}) => {
  switch (input.type) {
    case 'cloudbeat/cis_aws':
      return /*#__PURE__*/_react.default.createElement(_aws_credentials_form.AwsCredentialsForm, (0, _extends2.default)({}, props, {
        input: input
      }));
    case 'cloudbeat/cis_eks':
      return /*#__PURE__*/_react.default.createElement(_eks_credentials_form.EksCredentialsForm, (0, _extends2.default)({}, props, {
        input: input
      }));
    default:
      return null;
  }
};
exports.PolicyTemplateVarsForm = PolicyTemplateVarsForm;
const PolicyTemplateInfo = ({
  postureType
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  size: "s"
}, postureType === _constants.KSPM_POLICY_TEMPLATE && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.fleetIntegration.configureKspmIntegrationDescription",
  defaultMessage: "Select the Kubernetes cluster type you want to monitor and then fill in the name and description to help identify this integration"
}), postureType === _constants.CSPM_POLICY_TEMPLATE && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.fleetIntegration.configureCspmIntegrationDescription",
  defaultMessage: "Select the cloud service provider (CSP) you want to monitor and then fill in the name and description to help identify this integration"
}), postureType === _constants.VULN_MGMT_POLICY_TEMPLATE && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  iconType: "iInCircle",
  color: "primary",
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.cnvm.additionalChargesCalloutTitle",
    defaultMessage: "Additional charges on cloud provider billing account."
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.fleetIntegration.cnvm.additionalChargesCalloutDescription",
  defaultMessage: "Please note that using this service may result in additional charges on your next cloud provider billing statement due to increased usage."
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.fleetIntegration.cnvm.configureIntegrationDescription",
  defaultMessage: "Select the cloud service provider (CSP) you want to monitor and then fill in the name and description to help identify this integration"
})));
exports.PolicyTemplateInfo = PolicyTemplateInfo;
const PolicyTemplateInputSelector = ({
  input,
  disabled,
  setInput
}) => {
  const baseOptions = (0, _utils.getPolicyTemplateInputOptions)(input.policy_template);
  const options = baseOptions.map(option => ({
    ...option,
    disabled: option.disabled || disabled,
    label: option.label,
    icon: option.icon
  }));
  return /*#__PURE__*/_react.default.createElement(_csp_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    idSelected: input.type,
    options: options,
    onChange: inputType => setInput(inputType),
    size: "m"
  });
};
exports.PolicyTemplateInputSelector = PolicyTemplateInputSelector;