"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CspPolicyTemplateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _helpers = require("../../../common/utils/helpers");
var _constants = require("../../../common/constants");
var _utils = require("./utils");
var _policy_template_selectors = require("./policy_template_selectors");
var _use_package_policy_list = require("../../common/api/use_package_policy_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_INPUT_TYPE = {
  kspm: _constants.CLOUDBEAT_VANILLA,
  cspm: _constants.CLOUDBEAT_AWS,
  vuln_mgmt: _constants.CLOUDBEAT_VULN_MGMT_AWS
};
const EditScreenStepTitle = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.fleetIntegration.integrationSettingsTitle",
  defaultMessage: "Integration Settings"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
const IntegrationSettings = ({
  onChange,
  fields
}) => /*#__PURE__*/_react.default.createElement("div", null, fields.map(({
  value,
  id,
  label,
  error
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  key: id,
  id: id,
  fullWidth: true,
  label: label,
  isInvalid: !!error,
  error: error
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  isInvalid: !!error,
  fullWidth: true,
  value: value,
  onChange: event => onChange(id, event.target.value)
}))));
const CspPolicyTemplateForm = /*#__PURE__*/(0, _react.memo)(({
  newPolicy,
  onChange,
  validationResults,
  isEditPage,
  packageInfo
}) => {
  const integrationParam = (0, _reactRouterDom.useParams)().integration;
  const integration = _constants.SUPPORTED_POLICY_TEMPLATES.includes(integrationParam) ? integrationParam : undefined;
  // Handling validation state
  const [isValid, setIsValid] = (0, _react.useState)(true);
  const input = getSelectedOption(newPolicy.inputs, integration);
  const updatePolicy = (0, _react.useCallback)(updatedPolicy => onChange({
    isValid,
    updatedPolicy
  }), [onChange, isValid]);
  /**
   * - Updates policy inputs by user selection
   * - Updates hidden policy vars
   */
  const setEnabledPolicyInput = (0, _react.useCallback)(inputType => {
    const inputVars = (0, _utils.getPostureInputHiddenVars)(inputType, packageInfo);
    const policy = (0, _utils.getPosturePolicy)(newPolicy, inputType, inputVars);
    updatePolicy(policy);
  }, [newPolicy, updatePolicy, packageInfo]);

  // search for non null fields of the validation?.vars object
  const validationResultsNonNullFields = Object.keys((validationResults === null || validationResults === void 0 ? void 0 : validationResults.vars) || {}).filter(key => ((validationResults === null || validationResults === void 0 ? void 0 : validationResults.vars) || {})[key] !== null);
  const [isLoading, setIsLoading] = (0, _react.useState)(validationResultsNonNullFields.length > 0);
  const [canFetchIntegration, setCanFetchIntegration] = (0, _react.useState)(true);

  // delaying component rendering due to a race condition issue from Fleet
  // TODO: remove this workaround when the following issue is resolved:
  // https://github.com/elastic/kibana/issues/153246
  (0, _react.useEffect)(() => {
    // using validation?.vars to know if the newPolicy state was reset due to race condition
    if (validationResultsNonNullFields.length > 0) {
      // Forcing rerender to recover from the validation errors state
      setIsLoading(true);
    }
    setTimeout(() => setIsLoading(false), 200);
  }, [validationResultsNonNullFields]);
  const {
    data: packagePolicyList,
    refetch
  } = (0, _use_package_policy_list.usePackagePolicyList)(packageInfo.name, {
    enabled: canFetchIntegration
  });
  (0, _react.useEffect)(() => {
    if (isEditPage) return;
    if (isLoading) return;
    // Pick default input type for policy template.
    // Only 1 enabled input is supported when all inputs are initially enabled.
    // Required for mount only to ensure a single input type is selected
    // This will remove errors in validationResults.vars
    setEnabledPolicyInput(DEFAULT_INPUT_TYPE[input.policy_template]);
    refetch();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isLoading, input.policy_template, isEditPage]);
  useEnsureDefaultNamespace({
    newPolicy,
    input,
    updatePolicy
  });
  useCloudFormationTemplate({
    packageInfo,
    updatePolicy,
    newPolicy
  });
  usePolicyTemplateInitialName({
    packagePolicyList: packagePolicyList === null || packagePolicyList === void 0 ? void 0 : packagePolicyList.items,
    isEditPage,
    isLoading,
    integration,
    newPolicy,
    updatePolicy,
    setCanFetchIntegration
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    })));
  }
  const integrationFields = [{
    id: 'name',
    value: newPolicy.name,
    error: (validationResults === null || validationResults === void 0 ? void 0 : validationResults.name) || null,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.integrationNameLabel",
      defaultMessage: "Name"
    })
  }, {
    id: 'description',
    value: newPolicy.description || '',
    error: (validationResults === null || validationResults === void 0 ? void 0 : validationResults.description) || null,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.integrationDescriptionLabel",
      defaultMessage: "Description"
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEditPage && /*#__PURE__*/_react.default.createElement(EditScreenStepTitle, null), !integration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_policy_template_selectors.PolicyTemplateSelector, {
    selectedTemplate: input.policy_template,
    policy: newPolicy,
    setPolicyTemplate: template => setEnabledPolicyInput(DEFAULT_INPUT_TYPE[template]),
    disabled: isEditPage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_policy_template_selectors.PolicyTemplateInfo, {
    postureType: input.policy_template
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_policy_template_selectors.PolicyTemplateInputSelector, {
    input: input,
    setInput: setEnabledPolicyInput,
    disabled: isEditPage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(IntegrationSettings, {
    fields: integrationFields,
    onChange: (field, value) => updatePolicy({
      ...newPolicy,
      [field]: value
    })
  }), /*#__PURE__*/_react.default.createElement(_policy_template_selectors.PolicyTemplateVarsForm, {
    input: input,
    newPolicy: newPolicy,
    updatePolicy: updatePolicy,
    packageInfo: packageInfo,
    onChange: onChange,
    setIsValid: setIsValid
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
});
exports.default = exports.CspPolicyTemplateForm = CspPolicyTemplateForm;
CspPolicyTemplateForm.displayName = 'CspPolicyTemplateForm';

// eslint-disable-next-line import/no-default-export

const useEnsureDefaultNamespace = ({
  newPolicy,
  input,
  updatePolicy
}) => {
  (0, _react.useEffect)(() => {
    if (newPolicy.namespace === _utils.POSTURE_NAMESPACE) return;
    const policy = {
      ...(0, _utils.getPosturePolicy)(newPolicy, input.type),
      namespace: _utils.POSTURE_NAMESPACE
    };
    updatePolicy(policy);
  }, [newPolicy, input, updatePolicy]);
};
const usePolicyTemplateInitialName = ({
  isEditPage,
  isLoading,
  integration,
  newPolicy,
  packagePolicyList,
  updatePolicy,
  setCanFetchIntegration
}) => {
  (0, _react.useEffect)(() => {
    if (!integration) return;
    if (isEditPage) return;
    if (isLoading) return;
    const packagePolicyListByIntegration = packagePolicyList === null || packagePolicyList === void 0 ? void 0 : packagePolicyList.filter(policy => {
      var _policy$vars, _policy$vars$posture;
      return (policy === null || policy === void 0 ? void 0 : (_policy$vars = policy.vars) === null || _policy$vars === void 0 ? void 0 : (_policy$vars$posture = _policy$vars.posture) === null || _policy$vars$posture === void 0 ? void 0 : _policy$vars$posture.value) === integration;
    });
    const currentIntegrationName = (0, _utils.getMaxPackageName)(integration, packagePolicyListByIntegration);
    if (newPolicy.name === currentIntegrationName) {
      return;
    }
    updatePolicy({
      ...newPolicy,
      name: currentIntegrationName
    });
    setCanFetchIntegration(false);
    // since this useEffect should only run on initial mount updatePolicy and newPolicy shouldn't re-trigger it
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isLoading, integration, isEditPage, packagePolicyList]);
};
const getSelectedOption = (options, policyTemplate = _constants.CSPM_POLICY_TEMPLATE) => {
  // Looks for the enabled deployment (aka input). By default, all inputs are disabled.
  // Initial state when all inputs are disabled is to choose the first available of the relevant policyTemplate
  // Default selected policy template is CSPM
  const selectedOption = options.find(i => i.enabled) || options.find(i => i.policy_template === policyTemplate) || options[0];
  (0, _helpers.assert)(selectedOption, 'Failed to determine selected option'); // We can't provide a default input without knowing the policy template
  (0, _helpers.assert)((0, _utils.isPostureInput)(selectedOption), 'Unknown option: ' + selectedOption.type);
  return selectedOption;
};

/**
 * Update CloudFormation template and stack name in the Agent Policy
 * based on the selected policy template
 */
const useCloudFormationTemplate = ({
  packageInfo,
  newPolicy,
  updatePolicy
}) => {
  var _newPolicy$vars;
  (0, _react.useEffect)(() => {
    var _newPolicy$inputs, _newPolicy$inputs$fin, _newPolicy$inputs$fin2, _newPolicy$inputs$fin3;
    const templateUrl = (0, _utils.getVulnMgmtCloudFormationDefaultValue)(packageInfo);

    // If the template is not available, do not update the policy
    if (templateUrl === '') return;
    const checkCurrentTemplate = newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$inputs = newPolicy.inputs) === null || _newPolicy$inputs === void 0 ? void 0 : (_newPolicy$inputs$fin = _newPolicy$inputs.find(i => i.type === _constants.CLOUDBEAT_VULN_MGMT_AWS)) === null || _newPolicy$inputs$fin === void 0 ? void 0 : (_newPolicy$inputs$fin2 = _newPolicy$inputs$fin.config) === null || _newPolicy$inputs$fin2 === void 0 ? void 0 : (_newPolicy$inputs$fin3 = _newPolicy$inputs$fin2.cloud_formation_template_url) === null || _newPolicy$inputs$fin3 === void 0 ? void 0 : _newPolicy$inputs$fin3.value;

    // If the template is already set, do not update the policy
    if (checkCurrentTemplate === templateUrl) return;
    updatePolicy === null || updatePolicy === void 0 ? void 0 : updatePolicy({
      ...newPolicy,
      inputs: newPolicy.inputs.map(input => {
        if (input.type === _constants.CLOUDBEAT_VULN_MGMT_AWS) {
          return {
            ...input,
            config: {
              cloud_formation_template_url: {
                value: templateUrl
              }
            }
          };
        }
        return input;
      })
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$vars = newPolicy.vars) === null || _newPolicy$vars === void 0 ? void 0 : _newPolicy$vars.cloud_formation_template_url, newPolicy, packageInfo]);
};