"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _test_subjects = require("./test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Loading = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "center",
  alignItems: "center",
  "data-test-subj": _test_subjects.CHART_PANEL_TEST_SUBJECTS.LOADING
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
  size: "m"
}));
const Error = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "center",
  alignItems: "center",
  "data-test-subj": _test_subjects.CHART_PANEL_TEST_SUBJECTS.ERROR
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  color: "subdued"
}, 'Error'));
const ChartPanel = ({
  title,
  hasBorder = true,
  isLoading,
  isError,
  children,
  rightSideItems
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const renderChart = () => {
    if (isLoading) return /*#__PURE__*/_react.default.createElement(Loading, null);
    if (isError) return /*#__PURE__*/_react.default.createElement(Error, null);
    return children;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: hasBorder,
    hasShadow: false,
    "data-test-subj": "chart-panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    style: {
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'spaceBetween'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      justifyContent: 'center'
    }
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    style: {
      lineHeight: 'initial',
      paddingLeft: euiTheme.size.s
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      flexDirection: 'row',
      gap: euiTheme.size.s
    }
  }, rightSideItems))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      height: '100%'
    }
  }, renderChart())));
};
exports.ChartPanel = ChartPanel;