"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statusColors = exports.cloudPostureIntegrations = exports.MAX_FINDINGS_TO_LOAD = exports.LOCAL_STORAGE_PAGE_SIZE_RULES_KEY = exports.LOCAL_STORAGE_PAGE_SIZE_FINDINGS_KEY = exports.LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY = exports.LOCAL_STORAGE_DASHBOARD_CLUSTER_SORT_KEY = exports.FINDINGS_DOCS_URL = exports.DEFAULT_VISIBLE_ROWS_PER_PAGE = exports.CSP_MOMENT_FORMAT = void 0;
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _constants = require("../../common/constants");
var _cis_eks_logo = _interopRequireDefault(require("../assets/icons/cis_eks_logo.svg"));
var _cis_aks_logo = _interopRequireDefault(require("../assets/icons/cis_aks_logo.svg"));
var _cis_gke_logo = _interopRequireDefault(require("../assets/icons/cis_gke_logo.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusColors = {
  passed: _uiTheme.euiThemeVars.euiColorSuccess,
  failed: _uiTheme.euiThemeVars.euiColorVis9
};
exports.statusColors = statusColors;
const CSP_MOMENT_FORMAT = 'MMMM D, YYYY @ HH:mm:ss.SSS';
exports.CSP_MOMENT_FORMAT = CSP_MOMENT_FORMAT;
const MAX_FINDINGS_TO_LOAD = 500;
exports.MAX_FINDINGS_TO_LOAD = MAX_FINDINGS_TO_LOAD;
const DEFAULT_VISIBLE_ROWS_PER_PAGE = 25;
exports.DEFAULT_VISIBLE_ROWS_PER_PAGE = DEFAULT_VISIBLE_ROWS_PER_PAGE;
const LOCAL_STORAGE_PAGE_SIZE_FINDINGS_KEY = 'cloudPosture:findings:pageSize';
exports.LOCAL_STORAGE_PAGE_SIZE_FINDINGS_KEY = LOCAL_STORAGE_PAGE_SIZE_FINDINGS_KEY;
const LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY = 'cloudPosture:benchmark:pageSize';
exports.LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY = LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY;
const LOCAL_STORAGE_PAGE_SIZE_RULES_KEY = 'cloudPosture:rules:pageSize';
exports.LOCAL_STORAGE_PAGE_SIZE_RULES_KEY = LOCAL_STORAGE_PAGE_SIZE_RULES_KEY;
const LOCAL_STORAGE_DASHBOARD_CLUSTER_SORT_KEY = 'cloudPosture:complianceDashboard:clusterSort';
exports.LOCAL_STORAGE_DASHBOARD_CLUSTER_SORT_KEY = LOCAL_STORAGE_DASHBOARD_CLUSTER_SORT_KEY;
const cloudPostureIntegrations = {
  cspm: {
    policyTemplate: _constants.CSPM_POLICY_TEMPLATE,
    name: _i18n.i18n.translate('xpack.csp.cspmIntegration.integration.nameTitle', {
      defaultMessage: 'Cloud Security Posture Management'
    }),
    shortName: _i18n.i18n.translate('xpack.csp.cspmIntegration.integration.shortNameTitle', {
      defaultMessage: 'CSPM'
    }),
    options: [{
      type: _constants.CLOUDBEAT_AWS,
      name: _i18n.i18n.translate('xpack.csp.cspmIntegration.awsOption.nameTitle', {
        defaultMessage: 'Amazon Web Services'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.cspmIntegration.awsOption.benchmarkTitle', {
        defaultMessage: 'CIS AWS'
      }),
      icon: 'logoAWS'
    }, {
      type: _constants.CLOUDBEAT_GCP,
      name: _i18n.i18n.translate('xpack.csp.cspmIntegration.gcpOption.nameTitle', {
        defaultMessage: 'GCP'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.cspmIntegration.gcpOption.benchmarkTitle', {
        defaultMessage: 'CIS GCP'
      }),
      disabled: true,
      icon: 'logoGCP',
      tooltip: _i18n.i18n.translate('xpack.csp.cspmIntegration.gcpOption.tooltipContent', {
        defaultMessage: 'Coming soon'
      })
    }, {
      type: _constants.CLOUDBEAT_AZURE,
      name: _i18n.i18n.translate('xpack.csp.cspmIntegration.azureOption.nameTitle', {
        defaultMessage: 'Azure'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.cspmIntegration.azureOption.benchmarkTitle', {
        defaultMessage: 'CIS Azure'
      }),
      disabled: true,
      icon: 'logoAzure',
      tooltip: _i18n.i18n.translate('xpack.csp.cspmIntegration.azureOption.tooltipContent', {
        defaultMessage: 'Coming soon'
      })
    }]
  },
  kspm: {
    policyTemplate: _constants.KSPM_POLICY_TEMPLATE,
    name: _i18n.i18n.translate('xpack.csp.kspmIntegration.integration.nameTitle', {
      defaultMessage: 'Kubernetes Security Posture Management'
    }),
    shortName: _i18n.i18n.translate('xpack.csp.kspmIntegration.integration.shortNameTitle', {
      defaultMessage: 'KSPM'
    }),
    options: [{
      type: _constants.CLOUDBEAT_VANILLA,
      name: _i18n.i18n.translate('xpack.csp.kspmIntegration.vanillaOption.nameTitle', {
        defaultMessage: 'Self-Managed'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.kspmIntegration.vanillaOption.benchmarkTitle', {
        defaultMessage: 'CIS Kubernetes'
      }),
      icon: 'logoKubernetes'
    }, {
      type: _constants.CLOUDBEAT_EKS,
      name: _i18n.i18n.translate('xpack.csp.kspmIntegration.eksOption.nameTitle', {
        defaultMessage: 'EKS'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.kspmIntegration.eksOption.benchmarkTitle', {
        defaultMessage: 'CIS EKS'
      }),
      icon: _cis_eks_logo.default,
      tooltip: _i18n.i18n.translate('xpack.csp.kspmIntegration.eksOption.tooltipContent', {
        defaultMessage: 'Elastic Kubernetes Service'
      })
    }, {
      type: _constants.CLOUDBEAT_AKS,
      name: _i18n.i18n.translate('xpack.csp.kspmIntegration.aksOption.nameTitle', {
        defaultMessage: 'AKS'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.kspmIntegration.aksOption.benchmarkTitle', {
        defaultMessage: 'CIS AKS'
      }),
      disabled: true,
      icon: _cis_aks_logo.default,
      tooltip: _i18n.i18n.translate('xpack.csp.kspmIntegration.aksOption.tooltipContent', {
        defaultMessage: 'Azure Kubernetes Service - Coming soon'
      })
    }, {
      type: _constants.CLOUDBEAT_GKE,
      name: _i18n.i18n.translate('xpack.csp.kspmIntegration.gkeOption.nameTitle', {
        defaultMessage: 'GKE'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.kspmIntegration.gkeOption.benchmarkTitle', {
        defaultMessage: 'CIS GKE'
      }),
      disabled: true,
      icon: _cis_gke_logo.default,
      tooltip: _i18n.i18n.translate('xpack.csp.kspmIntegration.gkeOption.tooltipContent', {
        defaultMessage: 'Google Kubernetes Engine - Coming soon'
      })
    }]
  },
  vuln_mgmt: {
    policyTemplate: _constants.VULN_MGMT_POLICY_TEMPLATE,
    name: 'Vulnerability Management',
    // TODO: we should use i18n and fix this
    shortName: 'VULN_MGMT',
    // TODO: we should use i18n and fix this
    options: [{
      type: _constants.CLOUDBEAT_VULN_MGMT_AWS,
      name: _i18n.i18n.translate('xpack.csp.vulnMgmtIntegration.awsOption.nameTitle', {
        defaultMessage: 'Amazon Web Services'
      }),
      icon: 'logoAWS',
      benchmark: 'N/A' // TODO: change benchmark to be optional
    }, {
      type: _constants.CLOUDBEAT_VULN_MGMT_GCP,
      name: _i18n.i18n.translate('xpack.csp.vulnMgmtIntegration.gcpOption.nameTitle', {
        defaultMessage: 'GCP'
      }),
      disabled: true,
      icon: 'logoGCP',
      tooltip: _i18n.i18n.translate('xpack.csp.vulnMgmtIntegration.gcpOption.tooltipContent', {
        defaultMessage: 'Coming soon'
      }),
      benchmark: 'N/A' // TODO: change benchmark to be optional
    }, {
      type: _constants.CLOUDBEAT_VULN_MGMT_AZURE,
      name: _i18n.i18n.translate('xpack.csp.vulnMgmtIntegration.azureOption.nameTitle', {
        defaultMessage: 'Azure'
      }),
      disabled: true,
      icon: 'logoAzure',
      tooltip: _i18n.i18n.translate('xpack.csp.vulnMgmtIntegration.azureOption.tooltipContent', {
        defaultMessage: 'Coming soon'
      }),
      benchmark: 'N/A' // TODO: change benchmark to be optional
    }]
  }
};
exports.cloudPostureIntegrations = cloudPostureIntegrations;
const FINDINGS_DOCS_URL = 'https://ela.st/findings';
exports.FINDINGS_DOCS_URL = FINDINGS_DOCS_URL;