"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _register_cloud_deployment_id_analytics_context = require("../common/register_cloud_deployment_id_analytics_context");
var _is_cloud_enabled = require("../common/is_cloud_enabled");
var _parse_deployment_id_from_deployment_url = require("../common/parse_deployment_id_from_deployment_url");
var _constants = require("../common/constants");
var _decode_cloud_id = require("../common/decode_cloud_id");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "isCloudEnabled", void 0);
    (0, _defineProperty2.default)(this, "contextProviders", []);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.isCloudEnabled = (0, _is_cloud_enabled.getIsCloudEnabled)(this.config.id);
    this.logger = initializerContext.logger.get();
  }
  setup(core) {
    var _decodedId, _decodedId2, _decodedId3, _decodedId4;
    (0, _register_cloud_deployment_id_analytics_context.registerCloudDeploymentMetadataAnalyticsContext)(core.analytics, this.config);
    const {
      id,
      cname,
      base_url: baseUrl,
      trial_end_date: trialEndDate,
      is_elastic_staff_owned: isElasticStaffOwned
    } = this.config;
    let decodedId;
    if (id) {
      decodedId = (0, _decode_cloud_id.decodeCloudId)(id, this.logger);
    }
    return {
      cloudId: id,
      deploymentId: (0, _parse_deployment_id_from_deployment_url.parseDeploymentIdFromDeploymentUrl)(this.config.deployment_url),
      cname,
      baseUrl,
      ...this.getCloudUrls(),
      elasticsearchUrl: (_decodedId = decodedId) === null || _decodedId === void 0 ? void 0 : _decodedId.elasticsearchUrl,
      kibanaUrl: (_decodedId2 = decodedId) === null || _decodedId2 === void 0 ? void 0 : _decodedId2.kibanaUrl,
      cloudHost: (_decodedId3 = decodedId) === null || _decodedId3 === void 0 ? void 0 : _decodedId3.host,
      cloudDefaultPort: (_decodedId4 = decodedId) === null || _decodedId4 === void 0 ? void 0 : _decodedId4.defaultPort,
      trialEndDate: trialEndDate ? new Date(trialEndDate) : undefined,
      isElasticStaffOwned,
      isCloudEnabled: this.isCloudEnabled,
      registerCloudService: contextProvider => {
        this.contextProviders.push(contextProvider);
      }
    };
  }
  start(coreStart) {
    coreStart.chrome.setHelpSupportUrl(_constants.ELASTIC_SUPPORT_LINK);

    // Nest all the registered context providers under the Cloud Services Provider.
    // This way, plugins only need to require Cloud's context provider to have all the enriched Cloud services.
    const CloudContextProvider = ({
      children
    }) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.contextProviders.reduce((acc, ContextProvider) => /*#__PURE__*/_react.default.createElement(ContextProvider, null, " ", acc, " "), children));
    };
    const {
      deploymentUrl,
      profileUrl,
      organizationUrl
    } = this.getCloudUrls();
    return {
      CloudContextProvider,
      isCloudEnabled: this.isCloudEnabled,
      cloudId: this.config.id,
      deploymentUrl,
      profileUrl,
      organizationUrl
    };
  }
  stop() {}
  getCloudUrls() {
    const {
      profile_url: profileUrl,
      organization_url: organizationUrl,
      deployment_url: deploymentUrl,
      base_url: baseUrl
    } = this.config;
    const fullCloudDeploymentUrl = (0, _utils.getFullCloudUrl)(baseUrl, deploymentUrl);
    const fullCloudProfileUrl = (0, _utils.getFullCloudUrl)(baseUrl, profileUrl);
    const fullCloudOrganizationUrl = (0, _utils.getFullCloudUrl)(baseUrl, organizationUrl);
    const fullCloudSnapshotsUrl = `${fullCloudDeploymentUrl}/${_constants.CLOUD_SNAPSHOTS_PATH}`;
    return {
      deploymentUrl: fullCloudDeploymentUrl,
      profileUrl: fullCloudProfileUrl,
      organizationUrl: fullCloudOrganizationUrl,
      snapshotsUrl: fullCloudSnapshotsUrl
    };
  }
}
exports.CloudPlugin = CloudPlugin;