"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUserMenuLinks = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createUserMenuLinks = cloud => {
  const {
    profileUrl,
    organizationUrl
  } = cloud;
  const userMenuLinks = [];
  if (profileUrl) {
    userMenuLinks.push({
      label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.profileLinkText', {
        defaultMessage: 'Edit profile'
      }),
      iconType: 'user',
      href: profileUrl,
      order: 100,
      setAsProfile: true
    });
  }
  if (organizationUrl) {
    userMenuLinks.push({
      label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.accountLinkText', {
        defaultMessage: 'Account & Billing'
      }),
      iconType: 'gear',
      href: organizationUrl,
      order: 200
    });
  }
  return userMenuLinks;
};
exports.createUserMenuLinks = createUserMenuLinks;