"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicySettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _utils = require("../../common/utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _control_settings = require("../control_settings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicySettings = ({
  policy,
  onChange
}) => {
  const [policyHasErrors, setPolicyHasErrors] = (0, _react.useState)(false);
  const controlInput = (0, _utils.getInputFromPolicy)(policy, _constants.INPUT_CONTROL);
  const controlEnabled = !!(controlInput !== null && controlInput !== void 0 && controlInput.enabled);
  const onToggleEnabled = (0, _react.useCallback)(e => {
    if (controlInput) {
      controlInput.enabled = e.target.checked;
      onChange({
        isValid: !policyHasErrors,
        updatedPolicy: {
          ...policy
        }
      });
    }
  }, [controlInput, onChange, policyHasErrors, policy]);
  const onNameChange = (0, _react.useCallback)(event => {
    const name = event.currentTarget.value;
    onChange({
      isValid: !policyHasErrors,
      updatedPolicy: {
        ...policy,
        name
      }
    });
  }, [onChange, policyHasErrors, policy]);
  const onDescriptionChange = (0, _react.useCallback)(event => {
    const description = event.currentTarget.value;
    onChange({
      isValid: !policyHasErrors,
      updatedPolicy: {
        ...policy,
        description
      }
    });
  }, [onChange, policyHasErrors, policy]);
  const onPolicyChange = (0, _react.useCallback)(props => {
    setPolicyHasErrors(!props.isValid);
    onChange(props);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.name,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "name",
    value: policy.name,
    onChange: onNameChange,
    "data-test-subj": "cloud-defend-policy-name"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.description,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    name: "name",
    value: policy.description,
    onChange: onDescriptionChange,
    "data-test-subj": "cloud-defend-policy-description",
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "cloud-defend-controltoggle",
    label: i18n.enableControl,
    checked: controlEnabled,
    onChange: onToggleEnabled
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, i18n.enableControlHelp))))), controlEnabled && /*#__PURE__*/_react.default.createElement(_control_settings.ControlSettings, {
    "data-test-subj": "cloud-defend-controlsettings",
    policy: policy,
    onChange: onPolicyChange
  }));
};
exports.PolicySettings = PolicySettings;