"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.warningFIMUsingSlashStarStarTitle = exports.warningFIMUsingSlashStarStarText = exports.unusedSelectorHelp = exports.unusedSelector = exports.selectorsHelp = exports.selectors = exports.responsesHelp = exports.responses = exports.remove = exports.processSelector = exports.processResponse = exports.networkSelector = exports.networkResponse = exports.name = exports.matchSelectors = exports.getSelectorIconTooltip = exports.getResponseIconTooltip = exports.getConditionHelpLabel = exports.fileSelector = exports.fileResponse = exports.excludeSelectors = exports.exclude = exports.errorValueRequired = exports.errorInvalidTargetFilePath = exports.errorInvalidProcessExecutable = exports.errorInvalidPodLabel = exports.errorInvalidName = exports.errorInvalidFullContainerImageName = exports.errorDuplicateName = exports.errorConditionRequired = exports.errorBlockActionRequiresTargetFilePath = exports.errorActionRequired = exports.duplicate = exports.conditions = exports.addSelectorCondition = exports.addSelector = exports.addResponse = exports.actions = exports.actionLog = exports.actionBlockHelp = exports.actionBlock = exports.actionAlertAndBlock = exports.actionAlert = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fileSelector = _i18n.i18n.translate('xpack.cloudDefend.fileSelector', {
  defaultMessage: 'File selector'
});
exports.fileSelector = fileSelector;
const processSelector = _i18n.i18n.translate('xpack.cloudDefend.processSelector', {
  defaultMessage: 'Process selector'
});
exports.processSelector = processSelector;
const networkSelector = _i18n.i18n.translate('xpack.cloudDefend.networkSelector', {
  defaultMessage: 'Network (coming soon)'
});
exports.networkSelector = networkSelector;
const fileResponse = _i18n.i18n.translate('xpack.cloudDefend.fileResponse', {
  defaultMessage: 'File response'
});
exports.fileResponse = fileResponse;
const processResponse = _i18n.i18n.translate('xpack.cloudDefend.processResponse', {
  defaultMessage: 'Process response'
});
exports.processResponse = processResponse;
const networkResponse = _i18n.i18n.translate('xpack.cloudDefend.networkResponse', {
  defaultMessage: 'Network (coming soon)'
});
exports.networkResponse = networkResponse;
const conditions = _i18n.i18n.translate('xpack.cloudDefend.conditions', {
  defaultMessage: 'Conditions: '
});
exports.conditions = conditions;
const duplicate = _i18n.i18n.translate('xpack.cloudDefend.controlDuplicate', {
  defaultMessage: 'Duplicate'
});
exports.duplicate = duplicate;
const remove = _i18n.i18n.translate('xpack.cloudDefend.controlRemove', {
  defaultMessage: 'Remove'
});
exports.remove = remove;
const selectors = _i18n.i18n.translate('xpack.cloudDefend.controlSelectors', {
  defaultMessage: 'Selectors'
});
exports.selectors = selectors;
const selectorsHelp = _i18n.i18n.translate('xpack.cloudDefend.controlSelectorsHelp', {
  defaultMessage: 'Create file or process selectors to match on operations and or conditions of interest.'
});
exports.selectorsHelp = selectorsHelp;
const responses = _i18n.i18n.translate('xpack.cloudDefend.controlResponses', {
  defaultMessage: 'Responses'
});
exports.responses = responses;
const responsesHelp = _i18n.i18n.translate('xpack.cloudDefend.controlResponsesHelp', {
  defaultMessage: 'Use responses to map one or more selectors to a set of actions. Selectors can also be used to "exclude" events.'
});
exports.responsesHelp = responsesHelp;
const matchSelectors = _i18n.i18n.translate('xpack.cloudDefend.controlMatchSelectors', {
  defaultMessage: 'Match selectors'
});
exports.matchSelectors = matchSelectors;
const excludeSelectors = _i18n.i18n.translate('xpack.cloudDefend.controlExcludeSelectors', {
  defaultMessage: 'Exclude selectors'
});
exports.excludeSelectors = excludeSelectors;
const exclude = _i18n.i18n.translate('xpack.cloudDefend.controlExclude', {
  defaultMessage: 'Exclude'
});
exports.exclude = exclude;
const actions = _i18n.i18n.translate('xpack.cloudDefend.controlResponseActions', {
  defaultMessage: 'Actions'
});
exports.actions = actions;
const actionLog = _i18n.i18n.translate('xpack.cloudDefend.controlResponseActionLog', {
  defaultMessage: 'Log'
});
exports.actionLog = actionLog;
const actionAlert = _i18n.i18n.translate('xpack.cloudDefend.controlResponseActionAlert', {
  defaultMessage: 'Alert'
});
exports.actionAlert = actionAlert;
const actionBlock = _i18n.i18n.translate('xpack.cloudDefend.controlResponseActionBlock', {
  defaultMessage: 'Block'
});
exports.actionBlock = actionBlock;
const actionBlockHelp = _i18n.i18n.translate('xpack.cloudDefend.controlResponseActionBlockHelp', {
  defaultMessage: 'Alert action must be enabled to block an event.'
});
exports.actionBlockHelp = actionBlockHelp;
const actionAlertAndBlock = _i18n.i18n.translate('xpack.cloudDefend.controlResponseActionAlertAndBlock', {
  defaultMessage: 'Alert and block'
});
exports.actionAlertAndBlock = actionAlertAndBlock;
const addResponse = _i18n.i18n.translate('xpack.cloudDefend.addResponse', {
  defaultMessage: 'Add response'
});
exports.addResponse = addResponse;
const addSelector = _i18n.i18n.translate('xpack.cloudDefend.addSelector', {
  defaultMessage: 'Add selector'
});
exports.addSelector = addSelector;
const addSelectorCondition = _i18n.i18n.translate('xpack.cloudDefend.addSelectorCondition', {
  defaultMessage: 'Add condition'
});
exports.addSelectorCondition = addSelectorCondition;
const name = _i18n.i18n.translate('xpack.cloudDefend.name', {
  defaultMessage: 'Name'
});
exports.name = name;
const unusedSelector = _i18n.i18n.translate('xpack.cloudDefend.unusedSelector', {
  defaultMessage: 'Not in use'
});
exports.unusedSelector = unusedSelector;
const unusedSelectorHelp = _i18n.i18n.translate('xpack.cloudDefend.unusedSelectorHelp', {
  defaultMessage: 'This selector is not in use by any response.'
});
exports.unusedSelectorHelp = unusedSelectorHelp;
const errorInvalidTargetFilePath = _i18n.i18n.translate('xpack.cloudDefend.errorInvalidTargetFilePath', {
  defaultMessage: '"Target file path" values must use absolute paths. A trailing * wildcard may be used to match all files in the target directory. Use double ** to match all files recursively. e.g /etc/**'
});
exports.errorInvalidTargetFilePath = errorInvalidTargetFilePath;
const errorInvalidProcessExecutable = _i18n.i18n.translate('xpack.cloudDefend.errorInvalidProcessExecutable', {
  defaultMessage: '"Process executable" values must use absolute paths. A trailing * wildcard may be used to match all files in the target directory. Use double ** to match all files recursively. e.g /usr/bin/**'
});
exports.errorInvalidProcessExecutable = errorInvalidProcessExecutable;
const errorInvalidPodLabel = _i18n.i18n.translate('xpack.cloudDefend.errorInvalidPodLabel', {
  defaultMessage: 'Kubernetes pod label values must have the format: "key:value". A wildcard "*" can be used at the end of the value. e.g. "key:val*". To match on an empty label value, use "key:".'
});
exports.errorInvalidPodLabel = errorInvalidPodLabel;
const errorInvalidFullContainerImageName = _i18n.i18n.translate('xpack.cloudDefend.errorInvalidFullContainerImageName', {
  defaultMessage: '"Full container image name" values must be in the format: image_repo/image_name e.g. "docker.io/nginx"'
});
exports.errorInvalidFullContainerImageName = errorInvalidFullContainerImageName;
const errorConditionRequired = _i18n.i18n.translate('xpack.cloudDefend.errorConditionRequired', {
  defaultMessage: 'At least one condition per selector is required.'
});
exports.errorConditionRequired = errorConditionRequired;
const errorDuplicateName = _i18n.i18n.translate('xpack.cloudDefend.errorDuplicateName', {
  defaultMessage: 'This name is already used by another selector.'
});
exports.errorDuplicateName = errorDuplicateName;
const errorInvalidName = _i18n.i18n.translate('xpack.cloudDefend.errorInvalidName', {
  defaultMessage: 'Selector names must be alphanumeric and contain no spaces.'
});
exports.errorInvalidName = errorInvalidName;
const errorValueRequired = _i18n.i18n.translate('xpack.cloudDefend.errorValueRequired', {
  defaultMessage: 'At least one value is required.'
});
exports.errorValueRequired = errorValueRequired;
const errorActionRequired = _i18n.i18n.translate('xpack.cloudDefend.errorActionRequired', {
  defaultMessage: 'At least one action is required.'
});
exports.errorActionRequired = errorActionRequired;
const errorBlockActionRequiresTargetFilePath = _i18n.i18n.translate('xpack.cloudDefend.errorBlockActionRequiresTargetFilePath', {
  defaultMessage: 'The "block" action requires targetFilePath be included in all "match" selectors using FIM operations or in at least one "exclude" selector. Note that selectors without operation will match on all operations, including createFile, modifyFile or deleteFile'
});
exports.errorBlockActionRequiresTargetFilePath = errorBlockActionRequiresTargetFilePath;
const warningFIMUsingSlashStarStarTitle = _i18n.i18n.translate('xpack.cloudDefend.warningFIMUsingSlashStarStarTitle', {
  defaultMessage: 'Warning: Blocking FIM operations'
});
exports.warningFIMUsingSlashStarStarTitle = warningFIMUsingSlashStarStarTitle;
const warningFIMUsingSlashStarStarText = _i18n.i18n.translate('xpack.cloudDefend.warningFIMUsingSlashStarStarText', {
  defaultMessage: 'It is dangerous to block FIM operations using a targetFilePath of /**. This can lead to system instability. Note that selectors without operation will match on all operations, including createFile, modifyFile or deleteFile'
});
exports.warningFIMUsingSlashStarStarText = warningFIMUsingSlashStarStarText;
const getSelectorIconTooltip = type => {
  switch (type) {
    case 'process':
      return _i18n.i18n.translate('xpack.cloudDefend.processSelectorIconTooltip', {
        defaultMessage: 'A process selector. Matches only on process operations.'
      });
    case 'file':
    default:
      return _i18n.i18n.translate('xpack.cloudDefend.fileSelectorIconTooltip', {
        defaultMessage: 'A file selector. Matches only on file operations.'
      });
  }
};
exports.getSelectorIconTooltip = getSelectorIconTooltip;
const getResponseIconTooltip = type => {
  switch (type) {
    case 'process':
      return _i18n.i18n.translate('xpack.cloudDefend.processResponseIconTooltip', {
        defaultMessage: 'A process response.\nOnly process selectors can be used to match/exclude.'
      });
    case 'file':
    default:
      return _i18n.i18n.translate('xpack.cloudDefend.fileResponseIconTooltip', {
        defaultMessage: 'A file response.\nOnly file selectors can be used to match/exclude.'
      });
  }
};
exports.getResponseIconTooltip = getResponseIconTooltip;
const getConditionHelpLabel = prop => {
  switch (prop) {
    case 'ignoreVolumeMounts':
      return _i18n.i18n.translate('xpack.cloudDefend.ignoreVolumeMountsHelp', {
        defaultMessage: 'Ignore operations on all volume mounts.'
      });
    case 'ignoreVolumeFiles':
      return _i18n.i18n.translate('xpack.cloudDefend.ignoreVolumeFilesHelp', {
        defaultMessage: 'Ignore operations on file mounts only. e.g mounted files, configMaps, secrets etc...'
      });
    default:
      return '';
  }
};
exports.getConditionHelpLabel = getConditionHelpLabel;