"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCommentRequestTypeExternalReferenceSO = void 0;
var _api = require("../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A type narrowing function for external reference saved object attachments.
 */
const isCommentRequestTypeExternalReferenceSO = context => {
  var _context$externalRefe;
  return context.type === _api.CommentType.externalReference && ((_context$externalRefe = context.externalReferenceStorage) === null || _context$externalRefe === void 0 ? void 0 : _context$externalRefe.type) === _api.ExternalReferenceStorageType.savedObject;
};
exports.isCommentRequestTypeExternalReferenceSO = isCommentRequestTypeExternalReferenceSO;