"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.valueToUpdateIsStatus = exports.valueToUpdateIsSettings = exports.getTypedPayload = exports.decodeSingleCaseMetricsResponse = exports.decodeCasesResponse = exports.decodeCaseUserActionsResponse = exports.decodeCaseUserActionStatsResponse = exports.decodeCaseResponse = exports.decodeCaseResolveResponse = exports.decodeCaseConfigureResponse = exports.decodeCaseConfigurationsResponse = exports.createUpdateSuccessToaster = exports.createToasterPlainError = exports.covertToSnakeCase = exports.constructReportersFilter = exports.constructAssigneesFilter = exports.ToasterError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _constants = require("../../common/constants");
var _api = require("../../common/api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTypedPayload = a => a;
exports.getTypedPayload = getTypedPayload;
const covertToSnakeCase = obj => (0, _lodash.transform)(obj, (acc, value, key, target) => {
  const camelKey = Array.isArray(target) ? key : (0, _lodash.snakeCase)(key);
  acc[camelKey] = (0, _lodash.isObject)(value) ? covertToSnakeCase(value) : value;
});
exports.covertToSnakeCase = covertToSnakeCase;
const createToasterPlainError = message => new ToasterError([message]);
exports.createToasterPlainError = createToasterPlainError;
const decodeCaseResponse = respCase => (0, _pipeable.pipe)(_api.CaseRt.decode(respCase), (0, _Either.fold)((0, _api.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCaseResponse = decodeCaseResponse;
const decodeCaseResolveResponse = respCase => (0, _pipeable.pipe)(_api.CaseResolveResponseRt.decode(respCase), (0, _Either.fold)((0, _api.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCaseResolveResponse = decodeCaseResolveResponse;
const decodeSingleCaseMetricsResponse = respCase => (0, _pipeable.pipe)(_api.SingleCaseMetricsResponseRt.decode(respCase), (0, _Either.fold)((0, _api.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeSingleCaseMetricsResponse = decodeSingleCaseMetricsResponse;
const decodeCasesResponse = respCase => (0, _pipeable.pipe)(_api.CasesRt.decode(respCase), (0, _Either.fold)((0, _api.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCasesResponse = decodeCasesResponse;
const decodeCaseConfigurationsResponse = respCase => {
  return (0, _pipeable.pipe)(_api.ConfigurationsRt.decode(respCase), (0, _Either.fold)((0, _api.throwErrors)(createToasterPlainError), _function.identity));
};
exports.decodeCaseConfigurationsResponse = decodeCaseConfigurationsResponse;
const decodeCaseConfigureResponse = respCase => (0, _pipeable.pipe)(_api.ConfigurationRt.decode(respCase), (0, _Either.fold)((0, _api.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCaseConfigureResponse = decodeCaseConfigureResponse;
const decodeCaseUserActionsResponse = respUserActions => (0, _pipeable.pipe)(_api.UserActionsRt.decode(respUserActions), (0, _Either.fold)((0, _api.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCaseUserActionsResponse = decodeCaseUserActionsResponse;
const decodeCaseUserActionStatsResponse = caseUserActionsStats => (0, _pipeable.pipe)(_api.CaseUserActionStatsResponseRt.decode(caseUserActionsStats), (0, _Either.fold)((0, _api.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCaseUserActionStatsResponse = decodeCaseUserActionStatsResponse;
const valueToUpdateIsSettings = (key, value) => key === 'settings';
exports.valueToUpdateIsSettings = valueToUpdateIsSettings;
const valueToUpdateIsStatus = (key, value) => key === 'status';
exports.valueToUpdateIsStatus = valueToUpdateIsStatus;
class ToasterError extends Error {
  constructor(messages) {
    super(messages[0]);
    (0, _defineProperty2.default)(this, "messages", void 0);
    this.name = 'ToasterError';
    this.messages = messages;
  }
}
exports.ToasterError = ToasterError;
const createUpdateSuccessToaster = (caseBeforeUpdate, caseAfterUpdate, key, value) => {
  const caseHasAlerts = caseBeforeUpdate.comments.some(comment => comment.type === _api.CommentType.alert);
  const toast = {
    title: i18n.UPDATED_CASE(caseAfterUpdate.title),
    className: 'eui-textBreakWord'
  };
  if (valueToUpdateIsSettings(key, value) && value !== null && value !== void 0 && value.syncAlerts && caseHasAlerts) {
    return {
      ...toast,
      title: i18n.SYNC_CASE(caseAfterUpdate.title)
    };
  }
  if (valueToUpdateIsStatus(key, value) && caseHasAlerts && caseBeforeUpdate.settings.syncAlerts) {
    return {
      ...toast,
      text: i18n.STATUS_CHANGED_TOASTER_TEXT
    };
  }
  return toast;
};
exports.createUpdateSuccessToaster = createUpdateSuccessToaster;
const constructAssigneesFilter = assignees => {
  var _assignees$map;
  return assignees === null || assignees.length > 0 ? {
    assignees: (_assignees$map = assignees === null || assignees === void 0 ? void 0 : assignees.map(assignee => assignee === null ? _constants.NO_ASSIGNEES_FILTERING_KEYWORD : assignee)) !== null && _assignees$map !== void 0 ? _assignees$map : _constants.NO_ASSIGNEES_FILTERING_KEYWORD
  } : {};
};
exports.constructAssigneesFilter = constructAssigneesFilter;
const constructReportersFilter = reporters => {
  return reporters.length > 0 ? {
    reporters: reporters.map(reporter => {
      var _reporter$username;
      if (reporter.profile_uid != null) {
        return reporter.profile_uid;
      }
      return (_reporter$username = reporter.username) !== null && _reporter$username !== void 0 ? _reporter$username : '';
    }).filter(reporterID => !(0, _lodash.isEmpty)(reporterID))
  } : {};
};
exports.constructReportersFilter = constructReportersFilter;