"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVisualizationAttachmentType = void 0;
var _react = _interopRequireDefault(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _visualizations = require("../../../common/constants/visualizations");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../client/attachment_framework/types");
var _open_lens_button = require("./open_lens_button");
var _lens_renderer = require("./lens_renderer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getOpenLensButton(attachmentId, props) {
  return /*#__PURE__*/_react.default.createElement(_open_lens_button.OpenLensButton, {
    attachmentId: attachmentId,
    attributes: props.attributes,
    timeRange: props.timeRange
  });
}
const getVisualizationAttachmentActions = (attachmentId, props) => [{
  type: _types.AttachmentActionType.CUSTOM,
  render: () => getOpenLensButton(attachmentId, props),
  isPrimary: false
}];
const LensAttachment = /*#__PURE__*/_react.default.memo(props => {
  const {
    attributes,
    timeRange
  } = props.persistableStateAttachmentState;
  return /*#__PURE__*/_react.default.createElement(_lens_renderer.LensRenderer, {
    attributes: attributes,
    timeRange: timeRange
  });
}, (prevProps, nextProps) => (0, _fastDeepEqual.default)(prevProps.persistableStateAttachmentState, nextProps.persistableStateAttachmentState));
LensAttachment.displayName = 'LensAttachment';
const LensAttachmentRendererLazyComponent = /*#__PURE__*/_react.default.lazy(async () => {
  return {
    default: LensAttachment
  };
});
const getVisualizationAttachmentViewObject = ({
  attachmentId,
  persistableStateAttachmentState
}) => {
  const {
    attributes: lensAttributes,
    timeRange: lensTimeRange
  } = persistableStateAttachmentState;
  return {
    event: i18n.ADDED_VISUALIZATION,
    timelineAvatar: 'lensApp',
    getActions: () => getVisualizationAttachmentActions(attachmentId, {
      attributes: lensAttributes,
      timeRange: lensTimeRange
    }),
    hideDefaultActions: false,
    children: LensAttachmentRendererLazyComponent
  };
};
const getVisualizationAttachmentType = () => ({
  id: _visualizations.LENS_ATTACHMENT_TYPE,
  icon: 'document',
  displayName: 'Visualizations',
  getAttachmentViewObject: getVisualizationAttachmentViewObject,
  getAttachmentRemovalObject: () => ({
    event: i18n.REMOVED_VISUALIZATION
  })
});
exports.getVisualizationAttachmentType = getVisualizationAttachmentType;