"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePushToService = void 0;
var _react = require("react");
var _use_post_push_to_service = require("../../containers/use_post_push_to_service");
var _helpers = require("./helpers");
var _api = require("../../../common/api");
var _use_on_refresh_case_view_page = require("../case_view/use_on_refresh_case_view_page");
var _use_get_action_license = require("../../containers/use_get_action_license");
var _use_cases_context = require("../cases_context/use_cases_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePushToService = ({
  caseId,
  caseStatus,
  caseConnectors,
  connector,
  isValidConnector
}) => {
  var _caseConnectors$conne, _caseConnectors$conne2;
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    isLoading,
    mutateAsync: pushCaseToExternalService
  } = (0, _use_post_push_to_service.usePostPushToService)();
  const refreshCaseViewPage = (0, _use_on_refresh_case_view_page.useRefreshCaseViewPage)();
  const {
    isLoading: isLoadingLicense,
    data: actionLicense = null
  } = (0, _use_get_action_license.useGetActionLicense)();
  const hasLicenseError = actionLicense != null && !actionLicense.enabledInLicense;
  const needsToBePushed = !!((_caseConnectors$conne = caseConnectors[connector.id]) !== null && _caseConnectors$conne !== void 0 && _caseConnectors$conne.push.needsToBePushed);
  const hasBeenPushed = !!((_caseConnectors$conne2 = caseConnectors[connector.id]) !== null && _caseConnectors$conne2 !== void 0 && _caseConnectors$conne2.push.hasBeenPushed);
  const handlePushToService = (0, _react.useCallback)(async () => {
    if (connector.id != null && connector.id !== 'none') {
      const theCase = await pushCaseToExternalService({
        caseId,
        connector
      });
      if (theCase != null) {
        refreshCaseViewPage();
      }
    }
  }, [caseId, connector, pushCaseToExternalService, refreshCaseViewPage]);
  const errorsMsg = (0, _react.useMemo)(() => {
    const errors = [];

    // these message require that the user do some sort of write action as a result of the message, readonly users won't
    // be able to perform such an action so let's not display the error to the user in that situation
    if (!permissions.update) {
      return errors;
    }

    /**
     * We show only one message to the user depending the scenario. The messages have a priority of importance.
     * Messages with higher priority are being shown first. The priority is defined by the order each message is returned.
     *
     * By priority of importance:
     * 1. Show license error.
     * 2. Show configuration error.
     * 3. Show connector missing information if the connector is set to none.
     * 4. Show an error message if the connector has been deleted or the user does not have access to it.
     * 5. Show case closed message.
     */

    if (hasLicenseError) {
      return [(0, _helpers.getLicenseError)()];
    }
    if (actionLicense != null && !actionLicense.enabledInConfig) {
      return [(0, _helpers.getKibanaConfigError)()];
    }
    if (connector.id === 'none' && !isLoadingLicense && !hasLicenseError) {
      return [(0, _helpers.getConnectorMissingInfo)()];
    }
    if (!isValidConnector && !isLoadingLicense && !hasLicenseError) {
      return [(0, _helpers.getDeletedConnectorError)()];
    }
    if (caseStatus === _api.CaseStatuses.closed) {
      return [(0, _helpers.getCaseClosedInfo)()];
    }
    return errors;
  }, [actionLicense, caseStatus, connector.id, hasLicenseError, isValidConnector, isLoadingLicense, permissions.update]);
  return {
    errorsMsg,
    hasErrorMessages: errorsMsg.length > 0,
    needsToBePushed,
    hasBeenPushed,
    isLoading: isLoading || isLoadingLicense,
    hasPushPermissions: permissions.push,
    hasLicenseError,
    handlePushToService
  };
};
exports.usePushToService = usePushToService;