"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateCaseModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _create_case_modal = require("./create_case_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateCaseModal = ({
  onCaseCreated
}) => {
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const closeModal = (0, _react.useCallback)(() => setIsModalOpen(false), []);
  const openModal = (0, _react.useCallback)(() => setIsModalOpen(true), []);
  const onSuccess = (0, _react.useCallback)(async theCase => {
    onCaseCreated(theCase);
    closeModal();
  }, [onCaseCreated, closeModal]);
  return (0, _react.useMemo)(() => ({
    modal: /*#__PURE__*/_react.default.createElement(_create_case_modal.CreateCaseModal, {
      isModalOpen: isModalOpen,
      onCloseCaseModal: closeModal,
      onSuccess: onSuccess
    }),
    isModalOpen,
    closeModal,
    openModal
  }), [closeModal, isModalOpen, onSuccess, openModal]);
};
exports.useCreateCaseModal = useCreateCaseModal;