"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plugin = exports.LensEditor = void 0;
var _operators = require("rxjs/operators");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("./constants");
var _context = require("../../context");
var _modal_container = require("./modal_container");
var _use_lens_draft_comment = require("./use_lens_draft_comment");
var _translations = require("./translations");
var _hooks = require("../../../../common/hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BetaBadgeWrapper = _styledComponents.default.span`
  display: inline-flex;

  .euiToolTipAnchor {
    display: inline-flex;
  }
`;
const DEFAULT_TIMERANGE = {
  from: 'now-7d',
  to: 'now',
  mode: 'relative'
};
const LensEditorComponent = ({
  node,
  onCancel,
  onSave
}) => {
  const location = (0, _reactRouterDom.useLocation)();
  const {
    application: {
      currentAppId$
    },
    embeddable,
    lens,
    storage,
    http,
    uiSettings,
    savedObjectsManagement,
    data: {
      query: {
        timefilter: {
          timefilter
        }
      }
    }
  } = (0, _kibana.useKibana)().services;
  const [currentAppId, setCurrentAppId] = (0, _react.useState)(undefined);
  const {
    draftComment,
    clearDraftComment
  } = (0, _use_lens_draft_comment.useLensDraftComment)();
  const commentEditorContext = (0, _react.useContext)(_context.CommentEditorContext);
  const markdownContext = (0, _react.useContext)(_eui.EuiMarkdownContext);
  const isMainApplication = (0, _hooks.useIsMainApplication)();
  const handleClose = (0, _react.useCallback)(() => {
    if (currentAppId) {
      embeddable === null || embeddable === void 0 ? void 0 : embeddable.getStateTransfer().getIncomingEmbeddablePackage(currentAppId, true);
      clearDraftComment();
    }
    onCancel();
  }, [clearDraftComment, currentAppId, embeddable, onCancel]);
  const handleAdd = (0, _react.useCallback)((attributes, timerange) => {
    onSave(`!{${_constants.ID}${JSON.stringify({
      timeRange: timerange,
      attributes
    })}}`, {
      block: true
    });
    handleClose();
  }, [handleClose, onSave]);
  const handleUpdate = (0, _react.useCallback)((attributes, timerange, position) => {
    markdownContext.replaceNode(position, `!{${_constants.ID}${JSON.stringify({
      timeRange: timerange,
      attributes
    })}}`);
    handleClose();
  }, [handleClose, markdownContext]);
  const originatingPath = (0, _react.useMemo)(() => isMainApplication ? `/insightsAndAlerting/cases${location.pathname}${location.search}` : `${location.pathname}${location.search}`, [isMainApplication, location.pathname, location.search]);
  const handleCreateInLensClick = (0, _react.useCallback)(() => {
    storage.set(_constants.DRAFT_COMMENT_STORAGE_ID, {
      commentId: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.editorId,
      comment: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.value,
      position: node === null || node === void 0 ? void 0 : node.position,
      caseTitle: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTitle,
      caseTags: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTags
    });
    lens === null || lens === void 0 ? void 0 : lens.navigateToPrefilledEditor(undefined, {
      originatingApp: currentAppId,
      originatingPath
    });
  }, [storage, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.editorId, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.value, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTitle, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTags, node === null || node === void 0 ? void 0 : node.position, lens, currentAppId, originatingPath]);
  const handleEditInLensClick = (0, _react.useCallback)((lensAttributes, timeRange = DEFAULT_TIMERANGE) => {
    storage.set(_constants.DRAFT_COMMENT_STORAGE_ID, {
      commentId: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.editorId,
      comment: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.value,
      position: node === null || node === void 0 ? void 0 : node.position,
      caseTitle: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTitle,
      caseTags: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTags
    });
    lens === null || lens === void 0 ? void 0 : lens.navigateToPrefilledEditor(lensAttributes || node !== null && node !== void 0 && node.attributes ? {
      id: '',
      timeRange,
      attributes: lensAttributes || (node === null || node === void 0 ? void 0 : node.attributes)
    } : undefined, {
      originatingApp: currentAppId,
      originatingPath
    });
  }, [storage, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.editorId, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.value, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTitle, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTags, node === null || node === void 0 ? void 0 : node.position, node === null || node === void 0 ? void 0 : node.attributes, lens, currentAppId, originatingPath]);
  const handleChooseLensSO = (0, _react.useCallback)((savedObjectId, savedObjectType, fullName, savedObject) => {
    handleEditInLensClick({
      ...savedObject.attributes,
      title: '',
      references: savedObject.references
    });
  }, [handleEditInLensClick]);
  const savedObjectMetaData = (0, _react.useMemo)(() => [{
    type: 'lens',
    getIconForSavedObject: () => 'lensApp',
    name: _i18n.i18n.translate('xpack.cases.markdownEditor.plugins.lens.insertLensSavedObjectModal.searchSelection.savedObjectType.lens', {
      defaultMessage: 'Lens'
    }),
    includeFields: ['*']
  }], []);
  (0, _react.useEffect)(() => {
    if (node !== null && node !== void 0 && node.attributes && currentAppId) {
      handleEditInLensClick(node.attributes, node.timeRange);
    }
  }, [handleEditInLensClick, node, currentAppId]);
  (0, _react.useEffect)(() => {
    const getCurrentAppId = async () => {
      const appId = await currentAppId$.pipe((0, _operators.first)()).toPromise();
      setCurrentAppId(appId);
    };
    getCurrentAppId();
  }, [currentAppId$]);
  (0, _react.useEffect)(() => {
    var _incomingEmbeddablePa, _incomingEmbeddablePa2, _incomingEmbeddablePa3;
    let incomingEmbeddablePackage;
    if (currentAppId) {
      incomingEmbeddablePackage = embeddable === null || embeddable === void 0 ? void 0 : embeddable.getStateTransfer().getIncomingEmbeddablePackage(currentAppId, true);
    }
    if (((_incomingEmbeddablePa = incomingEmbeddablePackage) === null || _incomingEmbeddablePa === void 0 ? void 0 : _incomingEmbeddablePa.type) === 'lens' && (_incomingEmbeddablePa2 = incomingEmbeddablePackage) !== null && _incomingEmbeddablePa2 !== void 0 && (_incomingEmbeddablePa3 = _incomingEmbeddablePa2.input) !== null && _incomingEmbeddablePa3 !== void 0 && _incomingEmbeddablePa3.attributes) {
      const lensTime = timefilter.getTime();
      const newTimeRange = lensTime !== null && lensTime !== void 0 && lensTime.from && lensTime !== null && lensTime !== void 0 && lensTime.to ? {
        from: lensTime.from,
        to: lensTime.to,
        mode: [lensTime.from, lensTime.to].join('').includes('now') ? 'relative' : 'absolute'
      } : undefined;
      if (draftComment !== null && draftComment !== void 0 && draftComment.position) {
        var _incomingEmbeddablePa4;
        handleUpdate((_incomingEmbeddablePa4 = incomingEmbeddablePackage) === null || _incomingEmbeddablePa4 === void 0 ? void 0 : _incomingEmbeddablePa4.input.attributes, newTimeRange, draftComment.position);
        return;
      }
      if (draftComment) {
        var _incomingEmbeddablePa5;
        handleAdd((_incomingEmbeddablePa5 = incomingEmbeddablePackage) === null || _incomingEmbeddablePa5 === void 0 ? void 0 : _incomingEmbeddablePa5.input.attributes, newTimeRange);
      }
    }
  }, [embeddable, storage, timefilter, currentAppId, handleAdd, handleUpdate, draftComment]);
  const createLensButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleCreateInLensClick,
    iconType: "plusInCircle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cases.markdownEditor.plugins.lens.createVisualizationButtonLabel",
    defaultMessage: "Create new"
  }));
  return /*#__PURE__*/_react.default.createElement(_modal_container.ModalContainer, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cases.markdownEditor.plugins.lens.addVisualizationModalTitle",
    defaultMessage: "Add visualization"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(BetaBadgeWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.cases.markdownEditor.plugins.lens.betaLabel', {
      defaultMessage: 'Beta'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.cases.markdownEditor.plugins.lens.betaDescription', {
      defaultMessage: 'This module is not GA. You can only insert one lens per comment for now. Please help us by reporting bugs.'
    })
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    key: "searchSavedObjectFinder",
    onChoose: handleChooseLensSO,
    showFilter: false,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cases.markdownEditor.plugins.lens.insertLensSavedObjectModal.searchSelection.notFoundLabel",
      defaultMessage: "No matching lens found."
    }),
    savedObjectMetaData: savedObjectMetaData,
    fixedPageSize: 10,
    services: {
      uiSettings,
      http,
      savedObjectsManagement
    },
    leftChildren: createLensButton,
    helpText: _i18n.i18n.translate('xpack.cases.markdownEditor.plugins.lens.savedObjects.finder.searchInputHelpText', {
      defaultMessage: 'Insert an existing lens visualization or create a new one. Any changes or new visualizations will only apply to this comment.'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleClose,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cases.markdownEditor.plugins.lens.closeButtonLabel",
    defaultMessage: "Close"
  }))));
};
LensEditorComponent.displayName = 'LensEditor';
const LensEditor = /*#__PURE__*/_react.default.memo(LensEditorComponent);
exports.LensEditor = LensEditor;
const plugin = {
  name: _constants.ID,
  button: {
    label: _translations.VISUALIZATION,
    iconType: 'lensApp'
  },
  helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "md",
    paddingSize: "s",
    fontSize: "l"
  }, '!{lens<config>}'),
  editor: LensEditor
};
exports.plugin = plugin;