"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNKNOWN_MIME_TYPE = exports.TYPE = exports.TEXT_MIME_TYPE = exports.SUCCESSFUL_UPLOAD_FILE_NAME = exports.SHOWING_FILES = exports.SEARCH_PLACEHOLDER = exports.RESULTS_COUNT = exports.REMOVED_FILE = exports.PDF_MIME_TYPE = exports.NO_PREVIEW = exports.NO_FILES = exports.NAME = exports.IMAGE_MIME_TYPE = exports.FILES_TABLE = exports.FAILED_UPLOAD = exports.DOWNLOAD_FILE = exports.DELETE_FILE_TITLE = exports.DELETE_FILE = exports.DELETE = exports.DATE_ADDED = exports.COMPRESSED_MIME_TYPE = exports.CLOSE_MODAL = exports.ADD_FILE = exports.ADDED_UNKNOWN_FILE = exports.ADDED = exports.ACTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTIONS = _i18n.i18n.translate('xpack.cases.caseView.files.actions', {
  defaultMessage: 'Actions'
});
exports.ACTIONS = ACTIONS;
const ADD_FILE = _i18n.i18n.translate('xpack.cases.caseView.files.addFile', {
  defaultMessage: 'Add file'
});
exports.ADD_FILE = ADD_FILE;
const CLOSE_MODAL = _i18n.i18n.translate('xpack.cases.caseView.files.closeModal', {
  defaultMessage: 'Close'
});
exports.CLOSE_MODAL = CLOSE_MODAL;
const DATE_ADDED = _i18n.i18n.translate('xpack.cases.caseView.files.dateAdded', {
  defaultMessage: 'Date added'
});
exports.DATE_ADDED = DATE_ADDED;
const DELETE_FILE = _i18n.i18n.translate('xpack.cases.caseView.files.deleteFile', {
  defaultMessage: 'Delete file'
});
exports.DELETE_FILE = DELETE_FILE;
const DOWNLOAD_FILE = _i18n.i18n.translate('xpack.cases.caseView.files.downloadFile', {
  defaultMessage: 'Download file'
});
exports.DOWNLOAD_FILE = DOWNLOAD_FILE;
const FILES_TABLE = _i18n.i18n.translate('xpack.cases.caseView.files.filesTable', {
  defaultMessage: 'Files table'
});
exports.FILES_TABLE = FILES_TABLE;
const NAME = _i18n.i18n.translate('xpack.cases.caseView.files.name', {
  defaultMessage: 'Name'
});
exports.NAME = NAME;
const NO_FILES = _i18n.i18n.translate('xpack.cases.caseView.files.noFilesAvailable', {
  defaultMessage: 'No files available'
});
exports.NO_FILES = NO_FILES;
const NO_PREVIEW = _i18n.i18n.translate('xpack.cases.caseView.files.noPreviewAvailable', {
  defaultMessage: 'No preview available'
});
exports.NO_PREVIEW = NO_PREVIEW;
const RESULTS_COUNT = _i18n.i18n.translate('xpack.cases.caseView.files.resultsCount', {
  defaultMessage: 'Showing'
});
exports.RESULTS_COUNT = RESULTS_COUNT;
const TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.type', {
  defaultMessage: 'Type'
});
exports.TYPE = TYPE;
const SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.caseView.files.searchPlaceholder', {
  defaultMessage: 'Search files'
});
exports.SEARCH_PLACEHOLDER = SEARCH_PLACEHOLDER;
const FAILED_UPLOAD = _i18n.i18n.translate('xpack.cases.caseView.files.failedUpload', {
  defaultMessage: 'Failed to upload file'
});
exports.FAILED_UPLOAD = FAILED_UPLOAD;
const UNKNOWN_MIME_TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.unknownMimeType', {
  defaultMessage: 'Unknown'
});
exports.UNKNOWN_MIME_TYPE = UNKNOWN_MIME_TYPE;
const IMAGE_MIME_TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.imageMimeType', {
  defaultMessage: 'Image'
});
exports.IMAGE_MIME_TYPE = IMAGE_MIME_TYPE;
const TEXT_MIME_TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.textMimeType', {
  defaultMessage: 'Text'
});
exports.TEXT_MIME_TYPE = TEXT_MIME_TYPE;
const COMPRESSED_MIME_TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.compressedMimeType', {
  defaultMessage: 'Compressed'
});
exports.COMPRESSED_MIME_TYPE = COMPRESSED_MIME_TYPE;
const PDF_MIME_TYPE = _i18n.i18n.translate('xpack.cases.caseView.files.pdfMimeType', {
  defaultMessage: 'PDF'
});
exports.PDF_MIME_TYPE = PDF_MIME_TYPE;
const SUCCESSFUL_UPLOAD_FILE_NAME = fileName => _i18n.i18n.translate('xpack.cases.caseView.files.successfulUploadFileName', {
  defaultMessage: 'File {fileName} uploaded successfully',
  values: {
    fileName
  }
});
exports.SUCCESSFUL_UPLOAD_FILE_NAME = SUCCESSFUL_UPLOAD_FILE_NAME;
const SHOWING_FILES = totalFiles => _i18n.i18n.translate('xpack.cases.caseView.files.showingFilesTitle', {
  values: {
    totalFiles
  },
  defaultMessage: 'Showing {totalFiles} {totalFiles, plural, =1 {file} other {files}}'
});
exports.SHOWING_FILES = SHOWING_FILES;
const ADDED = _i18n.i18n.translate('xpack.cases.caseView.files.added', {
  defaultMessage: 'added '
});
exports.ADDED = ADDED;
const ADDED_UNKNOWN_FILE = _i18n.i18n.translate('xpack.cases.caseView.files.addedUnknownFile', {
  defaultMessage: 'added an unknown file'
});
exports.ADDED_UNKNOWN_FILE = ADDED_UNKNOWN_FILE;
const DELETE = _i18n.i18n.translate('xpack.cases.caseView.files.delete', {
  defaultMessage: 'Delete'
});
exports.DELETE = DELETE;
const DELETE_FILE_TITLE = _i18n.i18n.translate('xpack.cases.caseView.files.deleteThisFile', {
  defaultMessage: 'Delete this file?'
});
exports.DELETE_FILE_TITLE = DELETE_FILE_TITLE;
const REMOVED_FILE = _i18n.i18n.translate('xpack.cases.caseView.files.removedFile', {
  defaultMessage: 'removed file'
});
exports.REMOVED_FILE = REMOVED_FILE;