"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCaseOwnerSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _common = require("@kbn/kibana-react-plugin/common");
var _common2 = require("../../../common");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SELECTABLE_OWNERS = Object.keys(_constants.OWNER_INFO);
const FIELD_NAME = 'selectedOwner';
const FullWidthKeyPadMenu = (0, _common.euiStyled)(_eui.EuiKeyPadMenu)`
  width: 100%;
`;
const FullWidthKeyPadItem = (0, _common.euiStyled)(_eui.EuiKeyPadMenuItem)`

  width: 100%;
`;
const OwnerSelector = ({
  availableOwners,
  field,
  isLoading = false
}) => {
  const {
    errorMessage,
    isInvalid
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const radioGroupName = (0, _eui.useGeneratedHtmlId)({
    prefix: 'caseOwnerRadioGroup'
  });
  const onChange = (0, _react.useCallback)(val => field.setValue(val), [field]);
  (0, _react.useEffect)(() => {
    if (!field.value) {
      onChange(availableOwners.includes(_common2.SECURITY_SOLUTION_OWNER) ? _common2.SECURITY_SOLUTION_OWNER : availableOwners[0]);
    }
  }, [availableOwners, field.value, onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "caseOwnerSelector",
    fullWidth: true,
    isInvalid: isInvalid,
    error: errorMessage,
    helpText: field.helpText,
    label: field.label,
    labelAppend: field.labelAppend
  }, /*#__PURE__*/_react.default.createElement(FullWidthKeyPadMenu, {
    checkable: {
      ariaLegend: i18n.ARIA_KEYPAD_LEGEND
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, DEFAULT_SELECTABLE_OWNERS.map(owner => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: owner
  }, /*#__PURE__*/_react.default.createElement(FullWidthKeyPadItem, {
    "data-test-subj": `${owner}RadioButton`,
    onChange: onChange,
    checkable: "single",
    name: radioGroupName,
    id: owner,
    label: _constants.OWNER_INFO[owner].label,
    isSelected: field.value === owner,
    isDisabled: isLoading || !availableOwners.includes(owner)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _constants.OWNER_INFO[owner].iconType,
    size: "xl"
  })))))));
};
OwnerSelector.displayName = 'OwnerSelector';
const CaseOwnerSelector = ({
  availableOwners,
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: FIELD_NAME,
    component: OwnerSelector,
    componentProps: {
      availableOwners,
      isLoading
    }
  });
};
CaseOwnerSelector.displayName = 'CaseOwnerSelectionComponent';
const CreateCaseOwnerSelector = /*#__PURE__*/(0, _react.memo)(CaseOwnerSelector);
exports.CreateCaseOwnerSelector = CreateCaseOwnerSelector;