"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategoryComponent = /*#__PURE__*/_react.default.memo(({
  isLoading,
  onChange,
  category,
  availableCategories,
  isInvalid = false
}) => {
  const options = (0, _react.useMemo)(() => {
    return availableCategories.map(label => ({
      label
    }));
  }, [availableCategories]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(category != null ? [{
    label: category
  }] : []);
  const onComboChange = (0, _react.useCallback)(currentOptions => {
    var _currentOptions$;
    const value = (_currentOptions$ = currentOptions[0]) === null || _currentOptions$ === void 0 ? void 0 : _currentOptions$.label;
    setSelectedOptions(currentOptions);
    onChange(value);
  }, [onChange]);
  const onCreateOption = searchValue => {
    const normalizedSearchValue = searchValue.trim();
    const newOption = {
      label: normalizedSearchValue
    };
    onComboChange([newOption]);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    isLoading: isLoading,
    isDisabled: isLoading,
    isInvalid: isInvalid,
    options: options,
    "data-test-subj": "categories-list",
    selectedOptions: selectedOptions,
    onChange: onComboChange,
    onCreateOption: onCreateOption,
    "aria-label": "categories-list",
    isClearable: true,
    customOptionText: _translations.ADD_CATEGORY_CUSTOM_OPTION_LABEL_COMBO_BOX,
    isCaseSensitive: true
  });
});
exports.CategoryComponent = CategoryComponent;
CategoryComponent.displayName = 'CategoryComponent';