"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditCategory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _use_get_categories = require("../../../containers/use_get_categories");
var i18n = _interopRequireWildcard(require("../../category/translations"));
var _category_viewer_component = require("../../category/category_viewer_component");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _category_form_field = require("../../category/category_form_field");
var _removable_item = require("../../removable_item/removable_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategoryFormWrapper = ({
  category,
  availableCategories,
  isLoading,
  onChange
}) => {
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      category
    }
  });
  const {
    submit,
    isValid: isFormValid
  } = form;
  (0, _react.useEffect)(() => {
    if (onChange) {
      onChange({
        isValid: isFormValid,
        submit
      });
    }
  }, [isFormValid, onChange, submit]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_category_form_field.CategoryFormField, {
    isLoading: isLoading,
    availableCategories: availableCategories
  }));
};
CategoryFormWrapper.displayName = 'CategoryFormWrapper';
const EditCategory = /*#__PURE__*/_react.default.memo(({
  isLoading,
  onSubmit,
  category
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [isEditCategory, setIsEditCategory] = (0, _react.useState)(false);
  const {
    data: categories = [],
    isLoading: isLoadingCategories
  } = (0, _use_get_categories.useGetCategories)();
  const [formState, setFormState] = (0, _react.useState)({
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {}
    })
  });
  const onEdit = () => {
    setIsEditCategory(true);
  };
  const onCancel = () => {
    setIsEditCategory(false);
  };
  const removeCategory = () => {
    onSubmit(null);
    setIsEditCategory(false);
  };
  const onSubmitCategory = async () => {
    const {
      isValid,
      data
    } = await formState.submit();
    if (isValid) {
      const newCategory = data.category != null ? data.category : null;
      onSubmit(newCategory);
    }
    setIsEditCategory(false);
  };
  const isLoadingAll = isLoading || isLoadingCategories;
  const isCategoryValid = formState.isValid;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "cases-categories"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.CATEGORY)), isLoadingAll && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "category-loading"
  }), !isLoadingAll && permissions.update && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "category-edit-button",
    "aria-label": i18n.EDIT_CATEGORIES_ARIA,
    iconType: 'pencil',
    onClick: onEdit
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    "data-test-subj": "case-category"
  }, !isEditCategory && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, category ? /*#__PURE__*/_react.default.createElement(_removable_item.RemovableItem, {
    onRemoveItem: removeCategory,
    tooltipContent: i18n.REMOVE_CATEGORY,
    buttonAriaLabel: i18n.REMOVE_CATEGORY_ARIA_LABEL,
    dataTestSubjPrefix: "category"
  }, /*#__PURE__*/_react.default.createElement(_category_viewer_component.CategoryViewer, {
    category: category
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "no-categories"
  }, i18n.NO_CATEGORIES)), isEditCategory && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "edit-category",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(CategoryFormWrapper, {
    onChange: setFormState,
    category: category,
    availableCategories: categories,
    isLoading: isLoadingAll
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    "data-test-subj": "edit-category-submit",
    fill: true,
    iconType: "save",
    onClick: onSubmitCategory,
    size: "s",
    disabled: !isCategoryValid || isLoadingAll
  }, i18n.SAVE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "edit-category-cancel",
    iconType: "cross",
    onClick: onCancel,
    size: "s"
  }, i18n.CANCEL))))))));
});
exports.EditCategory = EditCategory;
EditCategory.displayName = 'EditCategory';