"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewTabs = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _types = require("../../../common/types");
var _navigation = require("../../common/navigation");
var _use_cases_context = require("../cases_context/use_cases_context");
var _translations = require("../header_page/translations");
var _translations2 = require("./translations");
var _use_get_case_file_stats = require("../../containers/use_get_case_file_stats");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExperimentalBadge = (0, _styledComponents.default)(_eui.EuiBetaBadge)`
  margin-left: 5px;
`;
const StyledNotificationBadge = (0, _styledComponents.default)(_eui.EuiNotificationBadge)`
  margin-left: 5px;
`;
const FilesTab = ({
  activeTab,
  fileStatsData,
  isLoading
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.FILES_TAB, !isLoading && fileStatsData && /*#__PURE__*/_react.default.createElement(StyledNotificationBadge, {
  "data-test-subj": "case-view-files-stats-badge",
  color: activeTab === _types.CASE_VIEW_PAGE_TABS.FILES ? 'accent' : 'subdued'
}, fileStatsData.total > 0 ? fileStatsData.total : 0));
const AlertsTab = ({
  activeTab,
  totalAlerts,
  isExperimental
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.ALERTS_TAB, /*#__PURE__*/_react.default.createElement(StyledNotificationBadge, {
  "data-test-subj": "case-view-alerts-stats-badge",
  color: activeTab === _types.CASE_VIEW_PAGE_TABS.ALERTS ? 'accent' : 'subdued'
}, totalAlerts || 0), isExperimental && /*#__PURE__*/_react.default.createElement(ExperimentalBadge, {
  label: _translations.EXPERIMENTAL_LABEL,
  size: "s",
  iconType: "beaker",
  tooltipContent: _translations.EXPERIMENTAL_DESC,
  tooltipPosition: "bottom",
  "data-test-subj": "case-view-alerts-table-experimental-badge"
}));
FilesTab.displayName = 'FilesTab';
AlertsTab.displayName = 'AlertsTab';
const CaseViewTabs = /*#__PURE__*/_react.default.memo(({
  caseData,
  activeTab
}) => {
  const {
    features
  } = (0, _use_cases_context.useCasesContext)();
  const {
    navigateToCaseView
  } = (0, _navigation.useCaseViewNavigation)();
  const {
    data: fileStatsData,
    isLoading
  } = (0, _use_get_case_file_stats.useGetCaseFileStats)({
    caseId: caseData.id
  });
  const tabs = (0, _react.useMemo)(() => [{
    id: _types.CASE_VIEW_PAGE_TABS.ACTIVITY,
    name: _translations2.ACTIVITY_TAB
  }, ...(features.alerts.enabled ? [{
    id: _types.CASE_VIEW_PAGE_TABS.ALERTS,
    name: /*#__PURE__*/_react.default.createElement(AlertsTab, {
      isExperimental: features.alerts.isExperimental,
      totalAlerts: caseData.totalAlerts,
      activeTab: activeTab
    })
  }] : []), {
    id: _types.CASE_VIEW_PAGE_TABS.FILES,
    name: /*#__PURE__*/_react.default.createElement(FilesTab, {
      isLoading: isLoading,
      fileStatsData: fileStatsData,
      activeTab: activeTab
    })
  }], [features.alerts.enabled, features.alerts.isExperimental, caseData.totalAlerts, activeTab, isLoading, fileStatsData]);
  const renderTabs = (0, _react.useCallback)(() => {
    return tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      "data-test-subj": `case-view-tab-title-${tab.id}`,
      key: index,
      onClick: () => navigateToCaseView({
        detailName: caseData.id,
        tabId: tab.id
      }),
      isSelected: tab.id === activeTab
    }, tab.name));
  }, [activeTab, caseData.id, navigateToCaseView, tabs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, renderTabs()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
});
exports.CaseViewTabs = CaseViewTabs;
CaseViewTabs.displayName = 'CaseViewTabs';