"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useItemsAction = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _use_bulk_update_case = require("../../containers/use_bulk_update_case");
var _use_cases_context = require("../cases_context/use_cases_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useItemsAction = ({
  isDisabled,
  fieldKey,
  onAction,
  onActionSuccess,
  successToasterTitle,
  fieldSelector,
  itemsTransformer
}) => {
  const {
    mutate: updateCases
  } = (0, _use_bulk_update_case.useUpdateCases)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const [selectedCasesToEdit, setSelectedCasesToEdit] = (0, _react.useState)([]);
  const canUpdateStatus = permissions.update;
  const isActionDisabled = isDisabled || !canUpdateStatus;
  const onFlyoutClosed = (0, _react.useCallback)(() => setIsFlyoutOpen(false), []);
  const openFlyout = (0, _react.useCallback)(selectedCases => {
    onAction();
    setIsFlyoutOpen(true);
    setSelectedCasesToEdit(selectedCases);
  }, [onAction]);
  const areItemsEqual = (originalItems, itemsToUpdate) => {
    return (0, _lodash.isEqual)(originalItems, itemsToUpdate);
  };
  const onSaveItems = (0, _react.useCallback)(itemsSelection => {
    onAction();
    onFlyoutClosed();
    const casesToUpdate = selectedCasesToEdit.reduce((acc, theCase) => {
      const caseFieldValue = fieldSelector(theCase);
      const itemsWithoutUnselectedItems = (0, _lodash.difference)(caseFieldValue, itemsSelection.unSelectedItems);
      const uniqueItems = new Set([...itemsWithoutUnselectedItems, ...itemsSelection.selectedItems]);
      if (areItemsEqual(new Set([...caseFieldValue]), uniqueItems)) {
        return acc;
      }
      return [...acc, {
        [fieldKey]: itemsTransformer(Array.from(uniqueItems.values())),
        id: theCase.id,
        version: theCase.version
      }];
    }, []);
    updateCases({
      cases: casesToUpdate,
      successToasterTitle: successToasterTitle(selectedCasesToEdit.length)
    }, {
      onSuccess: onActionSuccess
    });
  }, [fieldKey, fieldSelector, itemsTransformer, onAction, onActionSuccess, onFlyoutClosed, selectedCasesToEdit, successToasterTitle, updateCases]);
  return {
    isFlyoutOpen,
    onFlyoutClosed,
    onSaveItems,
    openFlyout,
    isActionDisabled
  };
};
exports.useItemsAction = useItemsAction;