"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_CASE = exports.VERSION_CONFLICT_WARNING = exports.UPDATED_ON = exports.UNKNOWN = exports.TO = exports.TITLE_REQUIRED = exports.TAGS_HELP = exports.TAGS_EMPTY_ERROR = exports.TAGS = exports.SYNC_ALERTS_SWITCH_LABEL_ON = exports.SYNC_ALERTS_SWITCH_LABEL_OFF = exports.SYNC_ALERTS_HELP = exports.SOLUTION_REQUIRED = exports.SOLUTION = exports.SET_SEVERITY_TO = exports.SELECT_CASE_TITLE = exports.SAVE = exports.REQUIRED_FIELD = exports.REPORTER = exports.REOPEN_CASE = exports.REMOVE_CATEGORY = exports.READ_ACTIONS_PERMISSIONS_ERROR_MSG = exports.PARTICIPANTS = exports.PAGE_TITLE = exports.OPTIONAL = exports.OPEN_CASES = exports.OPEN_CASE = exports.NO_TAGS_AVAILABLE = exports.NO_TAGS = exports.NO_REPORTERS_AVAILABLE = exports.NO_CONNECTOR = exports.NO_CATEGORIES_AVAILABLE = exports.NO_CATEGORIES = exports.NAME = exports.MAX_LENGTH_ERROR = exports.MARK_CASE_IN_PROGRESS = exports.MARKED_CASE_AS = exports.LINK_APPROPRIATE_LICENSE = exports.IN_PROGRESS_CASES = exports.EMPTY_COMMENTS_NOT_ALLOWED = exports.EDIT = exports.DESCRIPTION_REQUIRED = exports.DESCRIPTION = exports.DELETE_CASE = exports.DELETED_CASES = exports.CREATE_CASE_TITLE = exports.CREATE_CASE = exports.CREATED_ON = exports.COPY_ID_ACTION_SUCCESS = exports.COPY_ID_ACTION_LABEL = exports.CONNECTORS = exports.CONFIGURE_CASES_PAGE_TITLE = exports.CONFIGURE_CASES_BUTTON = exports.COMMENTS = exports.CLOSE_CASE = exports.CLOSED_ON = exports.CLOSED_CASES = exports.CATEGORY = exports.CATEGORIES = exports.CASE_SUCCESS_TOAST = exports.CASE_NAME = exports.CASE_ALERT_SUCCESS_TOAST = exports.CASE_ALERT_SUCCESS_SYNC_TEXT = exports.CANCEL = exports.BACK_TO_ALL = exports.ARIA_KEYPAD_LEGEND = exports.APP_TITLE = exports.APP_DESC = exports.ALERT_ADDED_TO_CASE = exports.ALERTS = exports.ALERT = exports.ADD_TAG_CUSTOM_OPTION_LABEL_COMBO_BOX = exports.ADD_TAG_CUSTOM_OPTION_LABEL = exports.ADD_COMMENT_HELP_TEXT = exports.ADD_COMMENT = exports.ADD_CATEGORY_CUSTOM_OPTION_LABEL_COMBO_BOX = exports.ADD_CATEGORY_CUSTOM_OPTION_LABEL = exports.ADD_CATEGORY = exports.ACTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BACK_TO_ALL = _i18n.i18n.translate('xpack.cases.caseView.backLabel', {
  defaultMessage: 'Back to cases'
});
exports.BACK_TO_ALL = BACK_TO_ALL;
const CANCEL = _i18n.i18n.translate('xpack.cases.caseView.cancel', {
  defaultMessage: 'Cancel'
});
exports.CANCEL = CANCEL;
const DELETE_CASE = (quantity = 1) => _i18n.i18n.translate('xpack.cases.confirmDeleteCase.deleteCase', {
  values: {
    quantity
  },
  defaultMessage: `Delete {quantity, plural, =1 {case} other {{quantity} cases}}`
});
exports.DELETE_CASE = DELETE_CASE;
const COPY_ID_ACTION_LABEL = _i18n.i18n.translate('xpack.cases.caseView.copyID', {
  defaultMessage: 'Copy Case ID'
});
exports.COPY_ID_ACTION_LABEL = COPY_ID_ACTION_LABEL;
const COPY_ID_ACTION_SUCCESS = _i18n.i18n.translate('xpack.cases.caseView.copyIDSuccess', {
  defaultMessage: 'Copied Case ID to clipboard'
});
exports.COPY_ID_ACTION_SUCCESS = COPY_ID_ACTION_SUCCESS;
const NAME = _i18n.i18n.translate('xpack.cases.caseView.name', {
  defaultMessage: 'Name'
});
exports.NAME = NAME;
const CREATED_ON = _i18n.i18n.translate('xpack.cases.caseView.createdOn', {
  defaultMessage: 'Created on'
});
exports.CREATED_ON = CREATED_ON;
const UPDATED_ON = _i18n.i18n.translate('xpack.cases.caseView.updatedOn', {
  defaultMessage: 'Updated on'
});
exports.UPDATED_ON = UPDATED_ON;
const CLOSED_ON = _i18n.i18n.translate('xpack.cases.caseView.closedOn', {
  defaultMessage: 'Closed on'
});
exports.CLOSED_ON = CLOSED_ON;
const REPORTER = _i18n.i18n.translate('xpack.cases.caseView.reporterLabel', {
  defaultMessage: 'Reporter'
});
exports.REPORTER = REPORTER;
const PARTICIPANTS = _i18n.i18n.translate('xpack.cases.caseView.particpantsLabel', {
  defaultMessage: 'Participants'
});
exports.PARTICIPANTS = PARTICIPANTS;
const CREATE_CASE_TITLE = _i18n.i18n.translate('xpack.cases.caseView.create', {
  defaultMessage: 'Create case'
});
exports.CREATE_CASE_TITLE = CREATE_CASE_TITLE;
const DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.description', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION = DESCRIPTION;
const DESCRIPTION_REQUIRED = _i18n.i18n.translate('xpack.cases.createCase.descriptionFieldRequiredError', {
  defaultMessage: 'A description is required.'
});
exports.DESCRIPTION_REQUIRED = DESCRIPTION_REQUIRED;
const SOLUTION_REQUIRED = _i18n.i18n.translate('xpack.cases.createCase.solutionFieldRequiredError', {
  defaultMessage: 'A solution is required'
});
exports.SOLUTION_REQUIRED = SOLUTION_REQUIRED;
const ARIA_KEYPAD_LEGEND = _i18n.i18n.translate('xpack.cases.createCase.ariaKeypadSolutionSelection', {
  defaultMessage: 'Single solution select'
});
exports.ARIA_KEYPAD_LEGEND = ARIA_KEYPAD_LEGEND;
const EMPTY_COMMENTS_NOT_ALLOWED = _i18n.i18n.translate('xpack.cases.caseView.commentFieldRequiredError', {
  defaultMessage: 'Empty comments are not allowed.'
});
exports.EMPTY_COMMENTS_NOT_ALLOWED = EMPTY_COMMENTS_NOT_ALLOWED;
const REQUIRED_FIELD = _i18n.i18n.translate('xpack.cases.caseView.fieldRequiredError', {
  defaultMessage: 'Required field'
});
exports.REQUIRED_FIELD = REQUIRED_FIELD;
const EDIT = _i18n.i18n.translate('xpack.cases.caseView.edit', {
  defaultMessage: 'Edit'
});
exports.EDIT = EDIT;
const OPTIONAL = _i18n.i18n.translate('xpack.cases.caseView.optional', {
  defaultMessage: 'Optional'
});
exports.OPTIONAL = OPTIONAL;
const PAGE_TITLE = _i18n.i18n.translate('xpack.cases.pageTitle', {
  defaultMessage: 'Cases'
});
exports.PAGE_TITLE = PAGE_TITLE;
const CREATE_CASE = _i18n.i18n.translate('xpack.cases.caseView.createCase', {
  defaultMessage: 'Create case'
});
exports.CREATE_CASE = CREATE_CASE;
const CLOSE_CASE = _i18n.i18n.translate('xpack.cases.caseView.closeCase', {
  defaultMessage: 'Close case'
});
exports.CLOSE_CASE = CLOSE_CASE;
const MARK_CASE_IN_PROGRESS = _i18n.i18n.translate('xpack.cases.caseView.markInProgress', {
  defaultMessage: 'Mark in progress'
});
exports.MARK_CASE_IN_PROGRESS = MARK_CASE_IN_PROGRESS;
const REOPEN_CASE = _i18n.i18n.translate('xpack.cases.caseView.reopenCase', {
  defaultMessage: 'Reopen case'
});
exports.REOPEN_CASE = REOPEN_CASE;
const OPEN_CASE = _i18n.i18n.translate('xpack.cases.caseView.openCase', {
  defaultMessage: 'Open case'
});
exports.OPEN_CASE = OPEN_CASE;
const CASE_NAME = _i18n.i18n.translate('xpack.cases.caseView.caseName', {
  defaultMessage: 'Case name'
});
exports.CASE_NAME = CASE_NAME;
const TO = _i18n.i18n.translate('xpack.cases.caseView.to', {
  defaultMessage: 'to'
});
exports.TO = TO;
const TAGS = _i18n.i18n.translate('xpack.cases.caseView.tags', {
  defaultMessage: 'Tags'
});
exports.TAGS = TAGS;
const CATEGORY = _i18n.i18n.translate('xpack.cases.caseView.category', {
  defaultMessage: 'Category'
});
exports.CATEGORY = CATEGORY;
const CATEGORIES = _i18n.i18n.translate('xpack.cases.caseView.categories', {
  defaultMessage: 'Categories'
});
exports.CATEGORIES = CATEGORIES;
const SOLUTION = _i18n.i18n.translate('xpack.cases.caseView.solution', {
  defaultMessage: 'Solution'
});
exports.SOLUTION = SOLUTION;
const ACTIONS = _i18n.i18n.translate('xpack.cases.allCases.actions', {
  defaultMessage: 'Actions'
});
exports.ACTIONS = ACTIONS;
const NO_TAGS_AVAILABLE = _i18n.i18n.translate('xpack.cases.allCases.noTagsAvailable', {
  defaultMessage: 'No tags available'
});
exports.NO_TAGS_AVAILABLE = NO_TAGS_AVAILABLE;
const NO_REPORTERS_AVAILABLE = _i18n.i18n.translate('xpack.cases.caseView.noReportersAvailable', {
  defaultMessage: 'No reporters available.'
});
exports.NO_REPORTERS_AVAILABLE = NO_REPORTERS_AVAILABLE;
const NO_CATEGORIES_AVAILABLE = _i18n.i18n.translate('xpack.cases.allCases.noCategoriesAvailable', {
  defaultMessage: 'No categories available'
});
exports.NO_CATEGORIES_AVAILABLE = NO_CATEGORIES_AVAILABLE;
const COMMENTS = _i18n.i18n.translate('xpack.cases.allCases.comments', {
  defaultMessage: 'Comments'
});
exports.COMMENTS = COMMENTS;
const TAGS_HELP = _i18n.i18n.translate('xpack.cases.createCase.fieldTagsHelpText', {
  defaultMessage: 'Separate tags with a line break.'
});
exports.TAGS_HELP = TAGS_HELP;
const TAGS_EMPTY_ERROR = _i18n.i18n.translate('xpack.cases.createCase.fieldTagsEmptyError', {
  defaultMessage: 'A tag must contain at least one non-space character.'
});
exports.TAGS_EMPTY_ERROR = TAGS_EMPTY_ERROR;
const NO_TAGS = _i18n.i18n.translate('xpack.cases.caseView.noTags', {
  defaultMessage: 'No tags are added'
});
exports.NO_TAGS = NO_TAGS;
const NO_CATEGORIES = _i18n.i18n.translate('xpack.cases.caseView.noCategories', {
  defaultMessage: 'No category is added'
});
exports.NO_CATEGORIES = NO_CATEGORIES;
const TITLE_REQUIRED = _i18n.i18n.translate('xpack.cases.createCase.titleFieldRequiredError', {
  defaultMessage: 'A name is required.'
});
exports.TITLE_REQUIRED = TITLE_REQUIRED;
const CONFIGURE_CASES_PAGE_TITLE = _i18n.i18n.translate('xpack.cases.configureCases.headerTitle', {
  defaultMessage: 'Configure cases'
});
exports.CONFIGURE_CASES_PAGE_TITLE = CONFIGURE_CASES_PAGE_TITLE;
const CONFIGURE_CASES_BUTTON = _i18n.i18n.translate('xpack.cases.configureCasesButton', {
  defaultMessage: 'Edit external connection'
});
exports.CONFIGURE_CASES_BUTTON = CONFIGURE_CASES_BUTTON;
const ADD_COMMENT = _i18n.i18n.translate('xpack.cases.caseView.comment.addComment', {
  defaultMessage: 'Add comment'
});
exports.ADD_COMMENT = ADD_COMMENT;
const ADD_COMMENT_HELP_TEXT = _i18n.i18n.translate('xpack.cases.caseView.comment.addCommentHelpText', {
  defaultMessage: 'Add a new comment...'
});
exports.ADD_COMMENT_HELP_TEXT = ADD_COMMENT_HELP_TEXT;
const SAVE = _i18n.i18n.translate('xpack.cases.caseView.description.save', {
  defaultMessage: 'Save'
});
exports.SAVE = SAVE;
const CONNECTORS = _i18n.i18n.translate('xpack.cases.caseView.connectors', {
  defaultMessage: 'External incident management system'
});
exports.CONNECTORS = CONNECTORS;
const NO_CONNECTOR = _i18n.i18n.translate('xpack.cases.common.noConnector', {
  defaultMessage: 'No connector selected'
});
exports.NO_CONNECTOR = NO_CONNECTOR;
const UNKNOWN = _i18n.i18n.translate('xpack.cases.caseView.unknown', {
  defaultMessage: 'Unknown'
});
exports.UNKNOWN = UNKNOWN;
const MARKED_CASE_AS = _i18n.i18n.translate('xpack.cases.caseView.markedCaseAs', {
  defaultMessage: 'marked case as'
});
exports.MARKED_CASE_AS = MARKED_CASE_AS;
const ADD_CATEGORY = _i18n.i18n.translate('xpack.cases.caseView.addCategory', {
  defaultMessage: 'added the category'
});
exports.ADD_CATEGORY = ADD_CATEGORY;
const REMOVE_CATEGORY = _i18n.i18n.translate('xpack.cases.caseView.userAction.removeCategory', {
  defaultMessage: 'removed the category'
});
exports.REMOVE_CATEGORY = REMOVE_CATEGORY;
const SET_SEVERITY_TO = _i18n.i18n.translate('xpack.cases.caseView.setSeverityTo', {
  defaultMessage: 'set severity to'
});
exports.SET_SEVERITY_TO = SET_SEVERITY_TO;
const OPEN_CASES = _i18n.i18n.translate('xpack.cases.caseTable.openCases', {
  defaultMessage: 'Open cases'
});
exports.OPEN_CASES = OPEN_CASES;
const CLOSED_CASES = _i18n.i18n.translate('xpack.cases.caseTable.closedCases', {
  defaultMessage: 'Closed cases'
});
exports.CLOSED_CASES = CLOSED_CASES;
const IN_PROGRESS_CASES = _i18n.i18n.translate('xpack.cases.caseTable.inProgressCases', {
  defaultMessage: 'In progress cases'
});
exports.IN_PROGRESS_CASES = IN_PROGRESS_CASES;
const SYNC_ALERTS_SWITCH_LABEL_ON = _i18n.i18n.translate('xpack.cases.settings.syncAlertsSwitchLabelOn', {
  defaultMessage: 'On'
});
exports.SYNC_ALERTS_SWITCH_LABEL_ON = SYNC_ALERTS_SWITCH_LABEL_ON;
const SYNC_ALERTS_SWITCH_LABEL_OFF = _i18n.i18n.translate('xpack.cases.settings.syncAlertsSwitchLabelOff', {
  defaultMessage: 'Off'
});
exports.SYNC_ALERTS_SWITCH_LABEL_OFF = SYNC_ALERTS_SWITCH_LABEL_OFF;
const SYNC_ALERTS_HELP = _i18n.i18n.translate('xpack.cases.components.create.syncAlertHelpText', {
  defaultMessage: 'Enabling this option will sync the alert statuses with the case status.'
});
exports.SYNC_ALERTS_HELP = SYNC_ALERTS_HELP;
const ALERT = _i18n.i18n.translate('xpack.cases.common.alertLabel', {
  defaultMessage: 'Alert'
});
exports.ALERT = ALERT;
const ALERTS = _i18n.i18n.translate('xpack.cases.common.alertsLabel', {
  defaultMessage: 'Alerts'
});
exports.ALERTS = ALERTS;
const ALERT_ADDED_TO_CASE = _i18n.i18n.translate('xpack.cases.common.alertAddedToCase', {
  defaultMessage: 'added to case'
});
exports.ALERT_ADDED_TO_CASE = ALERT_ADDED_TO_CASE;
const SELECT_CASE_TITLE = _i18n.i18n.translate('xpack.cases.common.allCases.caseModal.title', {
  defaultMessage: 'Select case'
});
exports.SELECT_CASE_TITLE = SELECT_CASE_TITLE;
const MAX_LENGTH_ERROR = (field, length) => _i18n.i18n.translate('xpack.cases.createCase.maxLengthError', {
  values: {
    field,
    length
  },
  defaultMessage: 'The length of the {field} is too long. The maximum length is {length}.'
});
exports.MAX_LENGTH_ERROR = MAX_LENGTH_ERROR;
const LINK_APPROPRIATE_LICENSE = _i18n.i18n.translate('xpack.cases.common.appropriateLicense', {
  defaultMessage: 'appropriate license'
});
exports.LINK_APPROPRIATE_LICENSE = LINK_APPROPRIATE_LICENSE;
const CASE_SUCCESS_TOAST = title => _i18n.i18n.translate('xpack.cases.actions.caseSuccessToast', {
  values: {
    title
  },
  defaultMessage: '{title} has been updated'
});
exports.CASE_SUCCESS_TOAST = CASE_SUCCESS_TOAST;
const CASE_ALERT_SUCCESS_TOAST = (title, quantity = 1) => _i18n.i18n.translate('xpack.cases.actions.caseAlertSuccessToast', {
  values: {
    quantity,
    title
  },
  defaultMessage: '{quantity, plural, =1 {An alert was} other {Alerts were}} added to "{title}"'
});
exports.CASE_ALERT_SUCCESS_TOAST = CASE_ALERT_SUCCESS_TOAST;
const CASE_ALERT_SUCCESS_SYNC_TEXT = _i18n.i18n.translate('xpack.cases.actions.caseAlertSuccessSyncText', {
  defaultMessage: 'The alert statuses are synched with the case status.'
});
exports.CASE_ALERT_SUCCESS_SYNC_TEXT = CASE_ALERT_SUCCESS_SYNC_TEXT;
const VIEW_CASE = _i18n.i18n.translate('xpack.cases.actions.viewCase', {
  defaultMessage: 'View case'
});
exports.VIEW_CASE = VIEW_CASE;
const APP_TITLE = _i18n.i18n.translate('xpack.cases.common.appTitle', {
  defaultMessage: 'Cases'
});
exports.APP_TITLE = APP_TITLE;
const APP_DESC = _i18n.i18n.translate('xpack.cases.common.appDescription', {
  defaultMessage: 'Open and track issues, push information to third party systems.'
});
exports.APP_DESC = APP_DESC;
const READ_ACTIONS_PERMISSIONS_ERROR_MSG = _i18n.i18n.translate('xpack.cases.configure.readPermissionsErrorDescription', {
  defaultMessage: 'You do not have permission to view connectors. If you would like to view connectors, contact your Kibana administrator.'
});
exports.READ_ACTIONS_PERMISSIONS_ERROR_MSG = READ_ACTIONS_PERMISSIONS_ERROR_MSG;
const DELETED_CASES = totalCases => _i18n.i18n.translate('xpack.cases.containers.deletedCases', {
  values: {
    totalCases
  },
  defaultMessage: 'Deleted {totalCases, plural, =1 {case} other {{totalCases} cases}}'
});
exports.DELETED_CASES = DELETED_CASES;
const ADD_TAG_CUSTOM_OPTION_LABEL = searchValue => _i18n.i18n.translate('xpack.cases.configure.addTagCustomOptionLabel', {
  defaultMessage: 'Add {searchValue} as a tag',
  values: {
    searchValue
  }
});
exports.ADD_TAG_CUSTOM_OPTION_LABEL = ADD_TAG_CUSTOM_OPTION_LABEL;
const ADD_CATEGORY_CUSTOM_OPTION_LABEL = searchValue => _i18n.i18n.translate('xpack.cases.configure.addCategoryCustomOptionLabel', {
  defaultMessage: 'Add {searchValue} as a category',
  values: {
    searchValue
  }
});
exports.ADD_CATEGORY_CUSTOM_OPTION_LABEL = ADD_CATEGORY_CUSTOM_OPTION_LABEL;
const VERSION_CONFLICT_WARNING = markdownId => _i18n.i18n.translate('xpack.cases.configure.commentVersionConflictWarning', {
  defaultMessage: 'This {markdownId} has been updated by another user. Saving your {markdownId} will overwrite their update.',
  values: {
    markdownId
  }
});

/**
 * EUI checkbox replace {searchValue} with the current
 * search value. We need to put the template variable
 * searchValue in the string but not replace it
 * with i18n.
 */
exports.VERSION_CONFLICT_WARNING = VERSION_CONFLICT_WARNING;
const ADD_TAG_CUSTOM_OPTION_LABEL_COMBO_BOX = ADD_TAG_CUSTOM_OPTION_LABEL('{searchValue}');
exports.ADD_TAG_CUSTOM_OPTION_LABEL_COMBO_BOX = ADD_TAG_CUSTOM_OPTION_LABEL_COMBO_BOX;
const ADD_CATEGORY_CUSTOM_OPTION_LABEL_COMBO_BOX = ADD_CATEGORY_CUSTOM_OPTION_LABEL('{searchValue}');
exports.ADD_CATEGORY_CUSTOM_OPTION_LABEL_COMBO_BOX = ADD_CATEGORY_CUSTOM_OPTION_LABEL_COMBO_BOX;