"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  CommentAttributesBasicRt: true,
  CommentType: true,
  IsolateHostActionType: true,
  ContextTypeUserRt: true,
  AlertCommentRequestRt: true,
  ActionsCommentRequestRt: true,
  ExternalReferenceStorageType: true,
  ExternalReferenceBaseRt: true,
  ExternalReferenceNoSORt: true,
  ExternalReferenceSORt: true,
  ExternalReferenceSOWithoutRefsRt: true,
  ExternalReferenceRt: true,
  ExternalReferenceWithoutRefsRt: true,
  PersistableStateAttachmentRt: true,
  AttributesTypeAlertsRt: true,
  CommentAttributesRt: true,
  CommentRequestRt: true,
  CommentRequestWithoutRefsRt: true,
  CommentRt: true,
  CommentResponseTypeUserRt: true,
  CommentResponseTypeAlertsRt: true,
  CommentResponseTypeActionsRt: true,
  CommentResponseTypeExternalReferenceRt: true,
  CommentResponseTypePersistableStateRt: true,
  CommentPatchRequestRt: true,
  CommentPatchAttributesRt: true,
  CommentsFindResponseRt: true,
  CommentsRt: true,
  FindCommentsQueryParamsRt: true,
  BulkCreateCommentRequestRt: true,
  BulkGetAttachmentsRequestRt: true,
  BulkGetAttachmentsResponseRt: true
};
exports.PersistableStateAttachmentRt = exports.IsolateHostActionType = exports.FindCommentsQueryParamsRt = exports.ExternalReferenceWithoutRefsRt = exports.ExternalReferenceStorageType = exports.ExternalReferenceSOWithoutRefsRt = exports.ExternalReferenceSORt = exports.ExternalReferenceRt = exports.ExternalReferenceNoSORt = exports.ExternalReferenceBaseRt = exports.ContextTypeUserRt = exports.CommentsRt = exports.CommentsFindResponseRt = exports.CommentType = exports.CommentRt = exports.CommentResponseTypeUserRt = exports.CommentResponseTypePersistableStateRt = exports.CommentResponseTypeExternalReferenceRt = exports.CommentResponseTypeAlertsRt = exports.CommentResponseTypeActionsRt = exports.CommentRequestWithoutRefsRt = exports.CommentRequestRt = exports.CommentPatchRequestRt = exports.CommentPatchAttributesRt = exports.CommentAttributesRt = exports.CommentAttributesBasicRt = exports.BulkGetAttachmentsResponseRt = exports.BulkGetAttachmentsRequestRt = exports.BulkCreateCommentRequestRt = exports.AttributesTypeAlertsRt = exports.AlertCommentRequestRt = exports.ActionsCommentRequestRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _runtime_types = require("../../runtime_types");
var _saved_object = require("../../saved_object");
var _user = require("../../user");
var _files = require("./files");
Object.keys(_files).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _files[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _files[key];
    }
  });
});
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommentAttributesBasicRt = rt.strict({
  created_at: rt.string,
  created_by: _user.UserRt,
  owner: rt.string,
  pushed_at: rt.union([rt.string, rt.null]),
  pushed_by: rt.union([_user.UserRt, rt.null]),
  updated_at: rt.union([rt.string, rt.null]),
  updated_by: rt.union([_user.UserRt, rt.null])
});
exports.CommentAttributesBasicRt = CommentAttributesBasicRt;
let CommentType;
exports.CommentType = CommentType;
(function (CommentType) {
  CommentType["user"] = "user";
  CommentType["alert"] = "alert";
  CommentType["actions"] = "actions";
  CommentType["externalReference"] = "externalReference";
  CommentType["persistableState"] = "persistableState";
})(CommentType || (exports.CommentType = CommentType = {}));
let IsolateHostActionType;
exports.IsolateHostActionType = IsolateHostActionType;
(function (IsolateHostActionType) {
  IsolateHostActionType["isolate"] = "isolate";
  IsolateHostActionType["unisolate"] = "unisolate";
})(IsolateHostActionType || (exports.IsolateHostActionType = IsolateHostActionType = {}));
const ContextTypeUserRt = rt.strict({
  comment: rt.string,
  type: rt.literal(CommentType.user),
  owner: rt.string
});

/**
 * This defines the structure of how alerts (generated or user attached) are stored in saved objects documents. It also
 * represents of an alert after it has been transformed. A generated alert will be transformed by the connector so that
 * it matches this structure. User attached alerts do not need to be transformed.
 */
exports.ContextTypeUserRt = ContextTypeUserRt;
const AlertCommentRequestRt = rt.strict({
  type: rt.literal(CommentType.alert),
  alertId: rt.union([rt.array(rt.string), rt.string]),
  index: rt.union([rt.array(rt.string), rt.string]),
  rule: rt.strict({
    id: rt.union([rt.string, rt.null]),
    name: rt.union([rt.string, rt.null])
  }),
  owner: rt.string
});
exports.AlertCommentRequestRt = AlertCommentRequestRt;
const ActionsCommentRequestRt = rt.strict({
  type: rt.literal(CommentType.actions),
  comment: rt.string,
  actions: rt.strict({
    targets: rt.array(rt.strict({
      hostname: rt.string,
      endpointId: rt.string
    })),
    type: rt.string
  }),
  owner: rt.string
});
exports.ActionsCommentRequestRt = ActionsCommentRequestRt;
let ExternalReferenceStorageType;
exports.ExternalReferenceStorageType = ExternalReferenceStorageType;
(function (ExternalReferenceStorageType) {
  ExternalReferenceStorageType["savedObject"] = "savedObject";
  ExternalReferenceStorageType["elasticSearchDoc"] = "elasticSearchDoc";
})(ExternalReferenceStorageType || (exports.ExternalReferenceStorageType = ExternalReferenceStorageType = {}));
const ExternalReferenceStorageNoSORt = rt.strict({
  type: rt.literal(ExternalReferenceStorageType.elasticSearchDoc)
});
const ExternalReferenceStorageSORt = rt.strict({
  type: rt.literal(ExternalReferenceStorageType.savedObject),
  soType: rt.string
});
const ExternalReferenceBaseRt = rt.strict({
  externalReferenceAttachmentTypeId: rt.string,
  externalReferenceMetadata: rt.union([rt.null, rt.record(rt.string, _runtime_types.jsonValueRt)]),
  type: rt.literal(CommentType.externalReference),
  owner: rt.string
});
exports.ExternalReferenceBaseRt = ExternalReferenceBaseRt;
const ExternalReferenceNoSORt = rt.strict({
  ...ExternalReferenceBaseRt.type.props,
  externalReferenceId: rt.string,
  externalReferenceStorage: ExternalReferenceStorageNoSORt
});
exports.ExternalReferenceNoSORt = ExternalReferenceNoSORt;
const ExternalReferenceSORt = rt.strict({
  ...ExternalReferenceBaseRt.type.props,
  externalReferenceId: rt.string,
  externalReferenceStorage: ExternalReferenceStorageSORt
});

// externalReferenceId is missing.
exports.ExternalReferenceSORt = ExternalReferenceSORt;
const ExternalReferenceSOWithoutRefsRt = rt.strict({
  ...ExternalReferenceBaseRt.type.props,
  externalReferenceStorage: ExternalReferenceStorageSORt
});
exports.ExternalReferenceSOWithoutRefsRt = ExternalReferenceSOWithoutRefsRt;
const ExternalReferenceRt = rt.union([ExternalReferenceNoSORt, ExternalReferenceSORt]);
exports.ExternalReferenceRt = ExternalReferenceRt;
const ExternalReferenceWithoutRefsRt = rt.union([ExternalReferenceNoSORt, ExternalReferenceSOWithoutRefsRt]);
exports.ExternalReferenceWithoutRefsRt = ExternalReferenceWithoutRefsRt;
const PersistableStateAttachmentRt = rt.strict({
  type: rt.literal(CommentType.persistableState),
  owner: rt.string,
  persistableStateAttachmentTypeId: rt.string,
  persistableStateAttachmentState: rt.record(rt.string, _runtime_types.jsonValueRt)
});
exports.PersistableStateAttachmentRt = PersistableStateAttachmentRt;
const AttributesTypeUserRt = rt.intersection([ContextTypeUserRt, CommentAttributesBasicRt]);
const AttributesTypeAlertsRt = rt.intersection([AlertCommentRequestRt, CommentAttributesBasicRt]);
exports.AttributesTypeAlertsRt = AttributesTypeAlertsRt;
const AttributesTypeActionsRt = rt.intersection([ActionsCommentRequestRt, CommentAttributesBasicRt]);
const AttributesTypeExternalReferenceRt = rt.intersection([ExternalReferenceRt, CommentAttributesBasicRt]);
const AttributesTypeExternalReferenceWithoutRefsRt = rt.intersection([ExternalReferenceWithoutRefsRt, CommentAttributesBasicRt]);
const AttributesTypeExternalReferenceNoSORt = rt.intersection([ExternalReferenceNoSORt, CommentAttributesBasicRt]);
const AttributesTypeExternalReferenceSORt = rt.intersection([ExternalReferenceSORt, CommentAttributesBasicRt]);
const AttributesTypePersistableStateRt = rt.intersection([PersistableStateAttachmentRt, CommentAttributesBasicRt]);
const CommentAttributesRt = rt.union([AttributesTypeUserRt, AttributesTypeAlertsRt, AttributesTypeActionsRt, AttributesTypeExternalReferenceRt, AttributesTypePersistableStateRt]);
exports.CommentAttributesRt = CommentAttributesRt;
const CommentAttributesNoSORt = rt.union([AttributesTypeUserRt, AttributesTypeAlertsRt, AttributesTypeActionsRt, AttributesTypeExternalReferenceNoSORt, AttributesTypePersistableStateRt]);
const CommentAttributesWithoutRefsRt = rt.union([AttributesTypeUserRt, AttributesTypeAlertsRt, AttributesTypeActionsRt, AttributesTypeExternalReferenceWithoutRefsRt, AttributesTypePersistableStateRt]);
const BasicCommentRequestRt = rt.union([ContextTypeUserRt, AlertCommentRequestRt, ActionsCommentRequestRt, ExternalReferenceNoSORt, PersistableStateAttachmentRt]);
const CommentRequestRt = rt.union([BasicCommentRequestRt, ExternalReferenceSORt]);
exports.CommentRequestRt = CommentRequestRt;
const CommentRequestWithoutRefsRt = rt.union([BasicCommentRequestRt, ExternalReferenceSOWithoutRefsRt]);
exports.CommentRequestWithoutRefsRt = CommentRequestWithoutRefsRt;
const CommentRt = rt.intersection([CommentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.CommentRt = CommentRt;
const CommentResponseTypeUserRt = rt.intersection([AttributesTypeUserRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.CommentResponseTypeUserRt = CommentResponseTypeUserRt;
const CommentResponseTypeAlertsRt = rt.intersection([AttributesTypeAlertsRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.CommentResponseTypeAlertsRt = CommentResponseTypeAlertsRt;
const CommentResponseTypeActionsRt = rt.intersection([AttributesTypeActionsRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.CommentResponseTypeActionsRt = CommentResponseTypeActionsRt;
const CommentResponseTypeExternalReferenceRt = rt.intersection([AttributesTypeExternalReferenceRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.CommentResponseTypeExternalReferenceRt = CommentResponseTypeExternalReferenceRt;
const CommentResponseTypePersistableStateRt = rt.intersection([AttributesTypePersistableStateRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.CommentResponseTypePersistableStateRt = CommentResponseTypePersistableStateRt;
const CommentPatchRequestRt = rt.intersection([
/**
 * Partial updates are not allowed.
 * We want to prevent the user for changing the type without removing invalid fields.
 *
 * injectAttachmentSOAttributesFromRefsForPatch is dependent on this assumption.
 * The consumers of the persistable attachment service should always get the
 * persistableStateAttachmentState on a patch.
 */
CommentRequestRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);

/**
 * This type is used by the CaseService.
 * Because the type for the attributes of savedObjectClient update function is Partial<T>
 * we need to make all of our attributes partial too.
 * We ensure that partial updates of CommentContext is not going to happen inside the patch comment route.
 */
exports.CommentPatchRequestRt = CommentPatchRequestRt;
const CommentPatchAttributesRt = rt.intersection([rt.union([rt.exact(rt.partial(ContextTypeUserRt.type.props)), rt.exact(rt.partial(AlertCommentRequestRt.type.props)), rt.exact(rt.partial(ActionsCommentRequestRt.type.props)), rt.exact(rt.partial(ExternalReferenceNoSORt.type.props)), rt.exact(rt.partial(ExternalReferenceSORt.type.props)), rt.exact(rt.partial(PersistableStateAttachmentRt.type.props))]), rt.exact(rt.partial(CommentAttributesBasicRt.type.props))]);
exports.CommentPatchAttributesRt = CommentPatchAttributesRt;
const CommentsFindResponseRt = rt.strict({
  comments: rt.array(CommentRt),
  page: rt.number,
  per_page: rt.number,
  total: rt.number
});
exports.CommentsFindResponseRt = CommentsFindResponseRt;
const CommentsRt = rt.array(CommentRt);
exports.CommentsRt = CommentsRt;
const FindCommentsQueryParamsRt = rt.exact(rt.partial({
  /**
   * The page of objects to return
   */
  page: rt.union([rt.number, _saved_object.NumberFromString]),
  /**
   * The number of objects to return for a page
   */
  perPage: rt.union([rt.number, _saved_object.NumberFromString]),
  /**
   * Order to sort the response
   */
  sortOrder: rt.union([rt.literal('desc'), rt.literal('asc')])
}));
exports.FindCommentsQueryParamsRt = FindCommentsQueryParamsRt;
const BulkCreateCommentRequestRt = rt.array(CommentRequestRt);
exports.BulkCreateCommentRequestRt = BulkCreateCommentRequestRt;
const BulkGetAttachmentsRequestRt = rt.strict({
  ids: rt.array(rt.string)
});
exports.BulkGetAttachmentsRequestRt = BulkGetAttachmentsRequestRt;
const BulkGetAttachmentsResponseRt = rt.strict({
  attachments: CommentsRt,
  errors: rt.array(rt.strict({
    error: rt.string,
    message: rt.string,
    status: rt.union([rt.undefined, rt.number]),
    attachmentId: rt.string
  }))
});
exports.BulkGetAttachmentsResponseRt = BulkGetAttachmentsResponseRt;